package com.thebeastshop.stock.dto;

import com.thebeastshop.common.BaseQueryCond;

import java.util.Date;
import java.util.List;

/**
 * @author gongjun
 * @since 2017-02-10
 */
public class SStockPresaleQueryDTO extends BaseQueryCond {
	/**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeEnd;
    /**
     * SKU CODE
     */
    private String skuCode;

    private List<String> skuCodeList;
    /**
     * 预售开始日期
     */
    private Date openTime;
    /**
     * 预售结束日期
     */
    private Date closeTime;
    /**
     * 预售结束日期小于
     */
    private Date closeTimeTo;
    /**
     * 是否获取销售详情
     * */
    private boolean cascade = true;

	/**
     * 预计发货日期
     */
    private Date planedDeliveryDate;
    private Date planedDeliveryDateTo;
    /**
     * 预售数量
     */
    private Integer totalQuantity;
    /**
     * 配送仓库编码
     */
    private String dispatchWarehouseCode;
    /**
     * 是否需要通知，0否1是
     */
    private Integer needNotify;
    /**
     * 通知发送时间
     */
    private Date notifyTime;
    /**
     * 通知邮件
     */
    private String notifyEmail;
    /**
     * 创建人ID
     */
    private Integer createOperatorId;
    /**
     * 创建人姓名
     */
    private String createOperatorName;
    /**
     * 预售说明
     */
    private String presaleDesc;
    /**
     * 状态 0-禁用，1-启用,2-待审批，-1-待启用
     */
    private Integer presaleStatus;
    
    private Integer channelType;

    private Integer presaleStatusNot;

    private Integer channelTypeNot;
    
    private List<Integer> channelTypeList;

    private List<Integer> categoryIds;
    
    private List<Integer> presaleStatusList;

    private Boolean  allotedEqualsTotal;  //是否满足已分配数量 = 预售数量

    public Integer getChannelType() {
		return channelType;
	}

	public void setChannelType(Integer channelType) {
		this.channelType = channelType;
	}

	private List<Long> ids;//预售id

    public SStockPresaleQueryDTO(){}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public Date getCreateTimeEnd() {
		return createTimeEnd;
	}

	public void setCreateTimeEnd(Date createTimeEnd) {
		this.createTimeEnd = createTimeEnd;
	}

	public String getSkuCode() {
		return skuCode;
	}

	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}

	public Date getOpenTime() {
		return openTime;
	}

	public void setOpenTime(Date openTime) {
		this.openTime = openTime;
	}

	public Date getCloseTime() {
		return closeTime;
	}

	public void setCloseTime(Date closeTime) {
		this.closeTime = closeTime;
	}

	public Date getCloseTimeTo() {
		return closeTimeTo;
	}

	public void setCloseTimeTo(Date closeTimeTo) {
		this.closeTimeTo = closeTimeTo;
	}

	public boolean isCascade() {
		return cascade;
	}

	public void setCascade(boolean cascade) {
		this.cascade = cascade;
	}

	public Date getPlanedDeliveryDate() {
		return planedDeliveryDate;
	}

	public void setPlanedDeliveryDate(Date planedDeliveryDate) {
		this.planedDeliveryDate = planedDeliveryDate;
	}

	public Date getPlanedDeliveryDateTo() {
		return planedDeliveryDateTo;
	}

	public void setPlanedDeliveryDateTo(Date planedDeliveryDateTo) {
		this.planedDeliveryDateTo = planedDeliveryDateTo;
	}

	public Integer getTotalQuantity() {
		return totalQuantity;
	}

	public void setTotalQuantity(Integer totalQuantity) {
		this.totalQuantity = totalQuantity;
	}

	public String getDispatchWarehouseCode() {
		return dispatchWarehouseCode;
	}

	public void setDispatchWarehouseCode(String dispatchWarehouseCode) {
		this.dispatchWarehouseCode = dispatchWarehouseCode;
	}

	public Integer getNeedNotify() {
		return needNotify;
	}

	public void setNeedNotify(Integer needNotify) {
		this.needNotify = needNotify;
	}

	public Date getNotifyTime() {
		return notifyTime;
	}

	public void setNotifyTime(Date notifyTime) {
		this.notifyTime = notifyTime;
	}

	public String getNotifyEmail() {
		return notifyEmail;
	}

	public void setNotifyEmail(String notifyEmail) {
		this.notifyEmail = notifyEmail;
	}

	public Integer getCreateOperatorId() {
		return createOperatorId;
	}

	public void setCreateOperatorId(Integer createOperatorId) {
		this.createOperatorId = createOperatorId;
	}

	public String getCreateOperatorName() {
		return createOperatorName;
	}

	public void setCreateOperatorName(String createOperatorName) {
		this.createOperatorName = createOperatorName;
	}

	public String getPresaleDesc() {
		return presaleDesc;
	}

	public void setPresaleDesc(String presaleDesc) {
		this.presaleDesc = presaleDesc;
	}

	public Integer getPresaleStatus() {
		return presaleStatus;
	}

	public void setPresaleStatus(Integer presaleStatus) {
		this.presaleStatus = presaleStatus;
	}

	public Integer getPresaleStatusNot() {
		return presaleStatusNot;
	}

	public void setPresaleStatusNot(Integer presaleStatusNot) {
		this.presaleStatusNot = presaleStatusNot;
	}

	public Integer getChannelTypeNot() {
		return channelTypeNot;
	}

	public void setChannelTypeNot(Integer channelTypeNot) {
		this.channelTypeNot = channelTypeNot;
	}

	public List<Integer> getChannelTypeList() {
		return channelTypeList;
	}

	public void setChannelTypeList(List<Integer> channelTypeList) {
		this.channelTypeList = channelTypeList;
	}

	public List<Integer> getCategoryIds() {
		return categoryIds;
	}

	public void setCategoryIds(List<Integer> categoryIds) {
		this.categoryIds = categoryIds;
	}

	public List<Integer> getPresaleStatusList() {
		return presaleStatusList;
	}

	public void setPresaleStatusList(List<Integer> presaleStatusList) {
		this.presaleStatusList = presaleStatusList;
	}

	public List<Long> getIds() {
		return ids;
	}

	public void setIds(List<Long> ids) {
		this.ids = ids;
	}

	public List<String> getSkuCodeList() {
		return skuCodeList;
	}

	public void setSkuCodeList(List<String> skuCodeList) {
		this.skuCodeList = skuCodeList;
	}

	public Boolean getAllotedEqualsTotal() {
		return allotedEqualsTotal;
	}

	public void setAllotedEqualsTotal(Boolean allotedEqualsTotal) {
		this.allotedEqualsTotal = allotedEqualsTotal;
	}
}
