/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.web.session;

import com.thebeastshop.ssoclient.web.session.MD5Utils;
import com.thebeastshop.ssoclient.web.session.StringUtils;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtil {
    private static final String KEY = "jkdflsffff()kldkjapfdY=::$B+DUOWAN";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private static String domain = "thebeastshop.com";

    public CookieUtil(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int seconds) {
        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(value)) {
            return;
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(seconds);
        cookie.setPath("/");
        response.setHeader("P3P", "CP='IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT'");
        response.addCookie(cookie);
    }

    public String getCookieValue(String name) throws UnsupportedEncodingException {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
                return cookies[i].getValue();
            }
        }
        return "";
    }

    public void setCheckCodeCookie(String name, String value, int seconds) {
        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(value)) {
            return;
        }
        String md5Value = MD5Utils.getMD5(KEY + value);
        Cookie cookie = new Cookie(name, md5Value);
        cookie.setMaxAge(seconds);
        cookie.setPath("/");
        this.response.addCookie(cookie);
    }

    public boolean checkCodeCookie(String name, String value) {
        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(value)) {
            return false;
        }
        boolean result = false;
        String cookieValue = CookieUtil.getCookieValue(this.request, name);
        if (MD5Utils.getMD5(KEY + value).equalsIgnoreCase(cookieValue)) {
            result = true;
        }
        return result;
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
                    return cookies[i].getValue();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static void removeCookieValue(HttpServletRequest request, HttpServletResponse response, String name) {
        block3: {
            try {
                Cookie[] cookies = request.getCookies();
                if (cookies == null || cookies.length <= 0) break block3;
                for (Cookie cookie : cookies) {
                    if (!name.equalsIgnoreCase(cookie.getName())) continue;
                    cookie = new Cookie(name, null);
                    cookie.setMaxAge(0);
                    cookie.setPath("/");
                    response.addCookie(cookie);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

