/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.cas.session;

import com.thebeastshop.ssoclient.cas.session.SessionMappingStorage;
import com.thebeastshop.ssoclient.cas.session.SingleSignOutFilter;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleSignOutHttpSessionListener
implements HttpSessionListener {
    private static final Logger log = LoggerFactory.getLogger(SingleSignOutHttpSessionListener.class);
    private SessionMappingStorage sessionMappingStorage;

    public void sessionCreated(HttpSessionEvent event) {
        if (event != null) {
            log.info("sessionCreated id={}", (Object)event.getSession().getId());
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (this.sessionMappingStorage == null) {
            log.info("getSessionMappingStorage");
            this.sessionMappingStorage = SingleSignOutHttpSessionListener.getSessionMappingStorage();
        }
        HttpSession session = event.getSession();
        log.info("sessionDestroyed removeBySessionById={}", (Object)session.getId());
        this.sessionMappingStorage.removeBySessionById(session.getId());
    }

    protected static SessionMappingStorage getSessionMappingStorage() {
        return SingleSignOutFilter.getSingleSignOutHandler().getSessionMappingStorage();
    }
}

