/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.cas.session;

import com.thebeastshop.ssoclient.cas.session.RedisBackedSessionMappingStorage;
import com.thebeastshop.ssoclient.cas.session.SessionMappingStorage;
import com.thebeastshop.ssoclient.cas.util.CommonUtils;
import com.thebeastshop.ssoclient.cas.util.XmlUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingleSignOutHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private SessionMappingStorage sessionMappingStorage = new RedisBackedSessionMappingStorage();
    private String artifactParameterName = "ticket";
    private String logoutParameterName = "logoutRequest";

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        this.sessionMappingStorage = storage;
    }

    public SessionMappingStorage getSessionMappingStorage() {
        return this.sessionMappingStorage;
    }

    public String getArtifactParameterName() {
        return this.artifactParameterName;
    }

    public void setArtifactParameterName(String name) {
        this.artifactParameterName = name;
    }

    public String getLogoutParameterName() {
        return this.logoutParameterName;
    }

    public void setLogoutParameterName(String name) {
        this.logoutParameterName = name;
    }

    public void init() {
        CommonUtils.assertNotNull(this.artifactParameterName, "artifactParameterName cannot be null.");
        CommonUtils.assertNotNull(this.logoutParameterName, "logoutParameterName cannot be null.");
        CommonUtils.assertNotNull(this.sessionMappingStorage, "sessionMappingStorage cannote be null.");
    }

    public boolean isTokenRequest(HttpServletRequest request) {
        return CommonUtils.isNotBlank(CommonUtils.safeGetParameter(request, this.artifactParameterName));
    }

    public boolean isLogoutRequest(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) && CommonUtils.isNotBlank(CommonUtils.safeGetParameter(request, this.logoutParameterName));
    }

    public void recordSession(HttpServletRequest request) {
        this.log.info((Object)"create session");
        HttpSession session = request.getSession(true);
        String token = CommonUtils.safeGetParameter(request, this.artifactParameterName);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Recording session for token " + token));
        }
        try {
            this.sessionMappingStorage.removeBySessionById(session.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.sessionMappingStorage.addSessionById(CommonUtils.safeGetParameter(request, this.artifactParameterName), session);
    }

    public void destroySession(HttpServletRequest request) {
        String token;
        String logoutMessage = CommonUtils.safeGetParameter(request, this.logoutParameterName);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Logout request:\n" + logoutMessage));
        }
        if (CommonUtils.isBlank(token = XmlUtils.getTextForElement(logoutMessage, "SessionIndex"))) {
            this.log.warn((Object)"token is null");
            return;
        }
        HttpSession session = this.sessionMappingStorage.removeSessionByMappingId(token);
        if (session == null) {
            this.log.info((Object)"session is null");
            return;
        }
        String sessionID = session.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Invalidating session [" + sessionID + "] for token [" + token + "]"));
        }
        try {
            this.log.info((Object)"session.invalidate()");
            session.invalidate();
        }
        catch (IllegalStateException e) {
            this.log.debug((Object)"Error invalidating session.", (Throwable)e);
        }
    }
}

