/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.cas.session;

import com.thebeastshop.ssoclient.cas.session.SessionMappingStorage;
import com.thebeastshop.ssoclient.cas.session.SingleSignOutHandler;
import com.thebeastshop.ssoclient.cas.util.AbstractConfigurationFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SingleSignOutFilter
extends AbstractConfigurationFilter {
    private static Log log = LogFactory.getLog(SingleSignOutFilter.class);
    private static final SingleSignOutHandler handler = new SingleSignOutHandler();

    public void init(FilterConfig filterConfig) throws ServletException {
        if (!this.isIgnoreInitConfiguration()) {
            handler.setArtifactParameterName(this.getPropertyFromInitParams(filterConfig, "artifactParameterName", "ticket"));
            handler.setLogoutParameterName(this.getPropertyFromInitParams(filterConfig, "logoutParameterName", "logoutRequest"));
        }
        handler.init();
    }

    public void setArtifactParameterName(String name) {
        handler.setArtifactParameterName(name);
    }

    public void setLogoutParameterName(String name) {
        handler.setLogoutParameterName(name);
    }

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        handler.setSessionMappingStorage(storage);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (handler.isTokenRequest(request)) {
            log.info((Object)"handler.isTokenRequest(request)");
            handler.recordSession(request);
        } else {
            if (handler.isLogoutRequest(request)) {
                log.info((Object)"handler.isLogoutRequest(request)");
                handler.destroySession(request);
                return;
            }
            log.info((Object)("Ignoring URI " + request.getRequestURI()));
            log.trace((Object)("Ignoring URI " + request.getRequestURI()));
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    protected static SingleSignOutHandler getSingleSignOutHandler() {
        return handler;
    }
}

