/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.cas.authentication;

import com.thebeastshop.ssoclient.cas.authentication.AttributePrincipal;
import com.thebeastshop.ssoclient.cas.authentication.SimplePrincipal;
import com.thebeastshop.ssoclient.cas.proxy.ProxyRetriever;
import com.thebeastshop.ssoclient.cas.util.CommonUtils;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttributePrincipalImpl
extends SimplePrincipal
implements AttributePrincipal {
    private static final Log LOG = LogFactory.getLog(AttributePrincipalImpl.class);
    private static final long serialVersionUID = -1443182634624927187L;
    private Map attributes;
    private String proxyGrantingTicket;
    private ProxyRetriever proxyRetriever;

    public AttributePrincipalImpl() {
    }

    public AttributePrincipalImpl(String name) {
        this(name, Collections.EMPTY_MAP);
    }

    public AttributePrincipalImpl(String name, Map attributes) {
        this(name, attributes, null, null);
    }

    public AttributePrincipalImpl(String name, String proxyGrantingTicket, ProxyRetriever proxyRetriever) {
        this(name, Collections.EMPTY_MAP, proxyGrantingTicket, proxyRetriever);
    }

    public AttributePrincipalImpl(String name, Map attributes, String proxyGrantingTicket, ProxyRetriever proxyRetriever) {
        super(name);
        this.attributes = attributes;
        this.proxyGrantingTicket = proxyGrantingTicket;
        this.proxyRetriever = proxyRetriever;
        CommonUtils.assertNotNull(this.attributes, "attributes cannot be null.");
    }

    @Override
    public Map getAttributes() {
        return this.attributes;
    }

    @Override
    public String getProxyTicketFor(String service) {
        if (this.proxyGrantingTicket != null) {
            return this.proxyRetriever.getProxyTicketIdFor(this.proxyGrantingTicket, service);
        }
        LOG.debug((Object)"No ProxyGrantingTicket was supplied, so no Proxy Ticket can be retrieved.");
        return null;
    }
}

