/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.share.order.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public enum EvaluateDisplayEnum {
    FULL_SITE_SELECTED(1, "\u5168\u7ad9\u7cbe\u9009"),
    PRODUCT_DETAIL(2, "\u5546\u54c1\u8be6\u60c5\u9875");

    private static final String DEFAULT_DISPLAY_MARK = "00000000";
    private static final Integer MARK_LENGTH;
    private static final char DEFAULT_FLAG = '0';
    private static final char DISPLAY_FLAG = '1';
    private Integer index;
    private String desc;

    public String getDesc() {
        return this.desc;
    }

    public Integer getIndex() {
        return this.index;
    }

    public static List<EvaluateDisplayEnum> getEnumsByDisplayMark(String displayMark) {
        ArrayList enums = Lists.newArrayList();
        for (EvaluateDisplayEnum evaluateDisplayEnum : EvaluateDisplayEnum.values()) {
            if ('1' != displayMark.charAt(evaluateDisplayEnum.index - 1)) continue;
            enums.add(evaluateDisplayEnum);
        }
        return enums;
    }

    public static String getDisplayMark(EvaluateDisplayEnum displayEnum) {
        if (displayEnum == null) {
            return DEFAULT_DISPLAY_MARK;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= MARK_LENGTH; ++i) {
            if (displayEnum.index.equals(i)) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }

    public static String getDisplayMark(List<EvaluateDisplayEnum> displayEnums) {
        if (CollectionUtils.isEmpty(displayEnums)) {
            return DEFAULT_DISPLAY_MARK;
        }
        List<Integer> indexs = EvaluateDisplayEnum.getDisplayEnumsIndex(displayEnums);
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= MARK_LENGTH; ++i) {
            if (indexs.contains(i)) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }

    public static List<String> getMarkByInDisplayEnums(List<EvaluateDisplayEnum> enums) {
        ArrayList displayMarks = Lists.newArrayList();
        if (CollectionUtils.isEmpty(enums)) {
            return displayMarks;
        }
        for (EvaluateDisplayEnum anEnum : enums) {
            displayMarks.addAll(EvaluateDisplayEnum.getMarkByInDisplayEnum(anEnum));
        }
        return displayMarks;
    }

    public static List<String> getMarkByInDisplayEnum(EvaluateDisplayEnum anEnum) {
        List<Object> displayMarks = Lists.newArrayList();
        Integer index = anEnum.index;
        List<Integer> indexs = EvaluateDisplayEnum.getDisplayEnumsIndex(Lists.newArrayList((Object[])EvaluateDisplayEnum.values()));
        for (int i = 1; i <= MARK_LENGTH; ++i) {
            displayMarks = index.equals(i) ? EvaluateDisplayEnum.addFlag2DisplayMark(displayMarks, true, false) : (indexs.contains(i) ? EvaluateDisplayEnum.addFlag2DisplayMark(displayMarks, true, true) : EvaluateDisplayEnum.addFlag2DisplayMark(displayMarks, false, true));
        }
        return displayMarks;
    }

    private static List<String> addFlag2DisplayMark(List<String> prefixs, Boolean displayFlag, Boolean defaultFlag) {
        ArrayList displayMarks = Lists.newArrayList();
        if (CollectionUtils.isEmpty(prefixs)) {
            if (displayFlag.booleanValue()) {
                displayMarks.add("1");
            }
            if (defaultFlag.booleanValue()) {
                displayMarks.add("0");
            }
        } else {
            for (String prefix : prefixs) {
                if (displayFlag.booleanValue()) {
                    displayMarks.add(prefix + '1');
                }
                if (!defaultFlag.booleanValue()) continue;
                displayMarks.add(prefix + '0');
            }
        }
        return displayMarks;
    }

    private static List<Integer> getDisplayEnumsIndex(List<EvaluateDisplayEnum> enums) {
        if (CollectionUtils.isEmpty(enums)) {
            return null;
        }
        ArrayList indexs = Lists.newArrayList();
        for (EvaluateDisplayEnum anEnum : enums) {
            indexs.add(anEnum.index);
        }
        return indexs;
    }

    private EvaluateDisplayEnum(Integer index, String desc) {
        this.index = index;
        this.desc = desc;
    }

    static {
        MARK_LENGTH = 8;
    }
}

