package com.thebeastshop.salesorder.enums;

public enum OrderTypeEnum {

	ORDERTYPE_0(0,"普通"),
	ORDERTYPE_1(1,"月送鲜花"),
	ORDERTYPE_2(2,"凑钱"),
	ORDERTYPE_3(3,"买赠"),
//	ORDERTYPE_4(4,"普通定制"),
//	ORDERTYPE_5(5,"配方定制"),
	ORDERTYPE_6(6,"浦发"),
	//ORDERTYPE_7(7,""),
	ORDERTYPE_8(8,"圣诞集赞兑换"),
	ORDERTYPE_9(9,"积分兑换"),
	ORDERTYPE_10(10,"团购"),
	ORDERTYPE_11(11,"定金"),
    ORDERTYPE_12(12, "尾款"),
    ORDERTYPE_13(13,"野兽课堂"),
	ORDERTYPE_14(14,"特殊折扣"),
	ORDERTYPE_15(15,"生日礼"),
	ORDERTYPE_16(16, "阶梯购"),
	ORDERTYPE_17(17, "微信送礼"),
	ORDERTYPE_20(20, "直播"),
	ORDERTYPE_21(21, "门店团购订单"),
	;

	private int code;

	private String name;

	OrderTypeEnum(int code, String name) {
		this.code = code;
		this.name = name;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public static OrderTypeEnum getEnumByCode(int code) {
		for (OrderTypeEnum e : OrderTypeEnum.values()) {
			if (e.getCode() == code) {
				return e;
			}
		}
		return null;
	}

	public void setName(String name) {
		this.name = name;
	}

}
