/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.salesorder.dto.SoReturnRequestCond;
import com.thebeastshop.salesorder.enums.SoPaymentTypeEnum;
import com.thebeastshop.salesorder.enums.SoReturnRequestStatusEnum;
import com.thebeastshop.salesorder.vo.inner.SoInOrderVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

import org.apache.commons.lang3.StringUtils;

/**
 * @author Eric.Lou
 * @version $Id: SoReturnRequestVO.java, v 0.1 2015-08-27 15:25
 */
public class SoReturnRequestVO extends BaseDO {

    private static final long serialVersionUID = 1L;

	// constructor
    public SoReturnRequestVO() {

    }

    // original
    private Long id;

    private Long salesOrderId;

    private String code;

    private Integer isChange;

    private String changeOrderCode;

    private Integer requestBy;

    private String requestChannelCode;

    private Integer needReturnInvoice;

    private String returnWarehouseCode;

    private String deliveryCode;

    private Integer returnStatus;

    private BigDecimal refundAmount;

    private Integer refundType;

    private String refundAccount;

    private Date createTime;

    private Date finishTime;
    
    private String 	  refundReason;		// 退款原因

    private String remark;

    private Long operatorId;

    private String operatorName;


    // self
    private SoReturnRefundVO opReturnRefundVO;//退货相关的退款

    private List<SoReturnRequestSkuVO> soReturnRequestSkuVOList;//退货SKU

    private SoInOrderVO opSalesOrderVO;

    private SoInOrderVO exchangeSalesOrderVO;//渠道换货单

    private String commandCode = "";//仓库指令

    private String returnWarehouseName = "";//退还仓库名称

    private String salesOrderCode = "";//订单编号

    private Integer needFinanceReturnRefund;//是否财务打款
    
    private BigDecimal aptGiftCardAmount;			// 礼品卡金额
    private String cardNum_Amount;					// 退礼品卡-金额对应数据（例：卡号_金额;卡号_金额）

    // manual generate
    public String getReturnStatusName() {
        if (returnStatus == null) return "";
        return SoReturnRequestStatusEnum.getNameById(returnStatus);
    }

    public String getRefundTypeName() {
        if (refundType == null) return "";
        return SoPaymentTypeEnum.getNameById(refundType);
    }

    // auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSalesOrderId() {
        return salesOrderId;
    }

    public void setSalesOrderId(Long salesOrderId) {
        this.salesOrderId = salesOrderId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getIsChange() {
        return isChange;
    }

    public void setIsChange(Integer isChange) {
        this.isChange = isChange;
    }

    public String getChangeOrderCode() {
        return changeOrderCode;
    }

    public void setChangeOrderCode(String changeOrderCode) {
        this.changeOrderCode = changeOrderCode;
    }

    public Integer getRequestBy() {
        return requestBy;
    }

    public void setRequestBy(Integer requestBy) {
        this.requestBy = requestBy;
    }

    public String getCardNum_Amount() {
		return cardNum_Amount;
	}
	public void setCardNum_Amount(String cardNum_Amount) {
		this.cardNum_Amount = cardNum_Amount;
	}

	public String getRequestChannelCode() {
        return requestChannelCode;
    }

    public void setRequestChannelCode(String requestChannelCode) {
        this.requestChannelCode = requestChannelCode;
    }

    public Integer getNeedReturnInvoice() {
        return needReturnInvoice;
    }

    public void setNeedReturnInvoice(Integer needReturnInvoice) {
        this.needReturnInvoice = needReturnInvoice;
    }

    public String getReturnWarehouseCode() {
        return returnWarehouseCode;
    }

    public void setReturnWarehouseCode(String returnWarehouseCode) {
        this.returnWarehouseCode = returnWarehouseCode;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public Integer getReturnStatus() {
        return returnStatus;
    }

    public void setReturnStatus(Integer returnStatus) {
        this.returnStatus = returnStatus;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public Integer getRefundType() {
        return refundType;
    }

    public void setRefundType(Integer refundType) {
        this.refundType = refundType;
    }

    public String getRefundAccount() {
        return refundAccount;
    }

    public void setRefundAccount(String refundAccount) {
        this.refundAccount = refundAccount;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public SoReturnRefundVO getOpReturnRefundVO() {
        return opReturnRefundVO;
    }

    public void setOpReturnRefundVO(SoReturnRefundVO opReturnRefundVO) {
        this.opReturnRefundVO = opReturnRefundVO;
    }

    public List<SoReturnRequestSkuVO> getSoReturnRequestSkuVOList() {
        return soReturnRequestSkuVOList;
    }

    public void setSoReturnRequestSkuVOList(List<SoReturnRequestSkuVO> soReturnRequestSkuVOList) {
        this.soReturnRequestSkuVOList = soReturnRequestSkuVOList;
    }

    public SoInOrderVO getOpSalesOrderVO() {
        return opSalesOrderVO;
    }

    public void setOpSalesOrderVO(SoInOrderVO opSalesOrderVO) {
        this.opSalesOrderVO = opSalesOrderVO;
    }

    public SoInOrderVO getExchangeSalesOrderVO() {
        return exchangeSalesOrderVO;
    }

    public void setExchangeSalesOrderVO(SoInOrderVO exchangeSalesOrderVO) {
        this.exchangeSalesOrderVO = exchangeSalesOrderVO;
    }

    public String getCommandCode() {
        return commandCode;
    }

    public void setCommandCode(String commandCode) {
        this.commandCode = commandCode;
    }

    public String getReturnWarehouseName() {
        return returnWarehouseName;
    }

    public void setReturnWarehouseName(String returnWarehouseName) {
        this.returnWarehouseName = returnWarehouseName;
    }

    public String getSalesOrderCode() {
        return salesOrderCode;
    }

    public void setSalesOrderCode(String salesOrderCode) {
        this.salesOrderCode = salesOrderCode;
    }

    public Integer getNeedFinanceReturnRefund() {
        return needFinanceReturnRefund;
    }

    public void setNeedFinanceReturnRefund(Integer needFinanceReturnRefund) {
        this.needFinanceReturnRefund = needFinanceReturnRefund;
    }

	public String getRefundReason() {
		return refundReason;
	}

	public void setRefundReason(String refundReason) {
		this.refundReason = refundReason;
	}

	public BigDecimal getAptGiftCardAmount() {
		return aptGiftCardAmount;
	}

	public void setAptGiftCardAmount(BigDecimal aptGiftCardAmount) {
		this.aptGiftCardAmount = aptGiftCardAmount;
	}

	public List<Map<String,Object>> getCardNum_AmountList(){
		List<Map<String,Object>> list= new ArrayList<>();
		if(!StringUtils.isBlank(cardNum_Amount)){
			String arr[] =  cardNum_Amount.split(";");
			if(arr != null && arr.length > 0){
				for(String str : arr){
					String cardNum_AmountSrr[] = str.split("_");
					if(cardNum_AmountSrr.length == 2){
						Map<String,Object> map = new HashMap<String,Object>();
						map.put("cardNum", cardNum_AmountSrr[0]);
						map.put("amount", cardNum_AmountSrr[1]);
						list.add(map);
					}
				}
			}
		}

		return list;
	}
}