package com.thebeastshop.salesorder.vo.pub;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: SoCateringOrderVO
 * @Description: ipos订单
 * @Author xiang.gao
 * @Date 2024/9/3 16:56
 */
public class SoIposOrderVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 订单ID
     */
    private Long id;

    /**
     * 订单号
     */
    private String code;

    /**
     * 会员CODE
     */
    private String memberCode;

    /**
     * 会员昵称
     */
    private String memberNick;

    /**
     * 会员手机号
     */
    private String memberMobile;

    /**
     * 渠道
     */
    private String channelCode;

    /**
     * 应付金额
     */
    private BigDecimal needToPayAmount = BigDecimal.ZERO;

    /**
     * 订单金额= 应付金额+礼品卡支付金额+储值卡支付金额
     */
    private BigDecimal orderPrice;

    /**
     * 订单状态
     */
    private Integer salesOrderStatus;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否可取消
     */
    private boolean cancelable;

    /**
     * 商品
     */
    private List<OrderSku> skuList;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getMemberNick() {
        return memberNick;
    }

    public void setMemberNick(String memberNick) {
        this.memberNick = memberNick;
    }

    public String getMemberMobile() {
        return memberMobile;
    }

    public void setMemberMobile(String memberMobile) {
        this.memberMobile = memberMobile;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public List<OrderSku> getSkuList() {
        return skuList;
    }

    public void setSkuList(List<OrderSku> skuList) {
        this.skuList = skuList;
    }

    public BigDecimal getNeedToPayAmount() {
        return needToPayAmount;
    }

    public void setNeedToPayAmount(BigDecimal needToPayAmount) {
        this.needToPayAmount = needToPayAmount;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean isCancelable() {
        return cancelable;
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    public BigDecimal getOrderPrice() {
        return orderPrice;
    }

    public void setOrderPrice(BigDecimal orderPrice) {
        this.orderPrice = orderPrice;
    }

    public Integer getSalesOrderStatus() {
        return salesOrderStatus;
    }

    public void setSalesOrderStatus(Integer salesOrderStatus) {
        this.salesOrderStatus = salesOrderStatus;
    }

    /**
     * 商品
     */
    public static class OrderSku implements Serializable{

        /**
         * skuCode
         */
        private String skuCode;

        /**
         * sku名称
         */
        private String nameCn;

        /**
         * 数量
         */
        private Integer quantity;

        /**
         * 单价
         */
        private BigDecimal unitPrice;

        public String getSkuCode() {
            return skuCode;
        }

        public void setSkuCode(String skuCode) {
            this.skuCode = skuCode;
        }

        public String getNameCn() {
            return nameCn;
        }

        public void setNameCn(String nameCn) {
            this.nameCn = nameCn;
        }

        public Integer getQuantity() {
            return quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public BigDecimal getUnitPrice() {
            return unitPrice;
        }

        public void setUnitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
        }
    }



}
