package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 15:12
 */
public enum SoInvoiceInfoTypeEnum {

    TYPE_NORMAL(1, "普通发票"),

    TYPE_VAT(2, "增值税发票增值税发票")

    ;

    private Integer id;

    private String name;

    SoInvoiceInfoTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }


    public String getName() {
        return name;
    }

    public static SoInvoiceInfoTypeEnum getEnumById(Integer id) {
        for (SoInvoiceInfoTypeEnum e : SoInvoiceInfoTypeEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoInvoiceInfoTypeEnum.class);
    }

}
