package com.thebeastshop.salesorder.vo.pub;

import com.thebeastshop.common.BaseDO;

import java.util.Date;

/***
 * package sku 中对应的扩展信息
 * @author fs
 *
 */
public class SoPsPackageSkuInnerVO extends BaseDO {

    private static final long serialVersionUID = -4578791745120064235L;


    private Integer id;
    /**
     * 哪个商品行sku的扩展信息
     */
    private Integer packageSkuId;

    /**
     * 期望收货日期
     */
    private Date expectReceiveDate;

    /**
     * 限时送达
     */
    private String limitDeliveryTime;

    /**
     * 主品的skuCode
     */
    private String mainSkuCode;

    /**
     * 主品的spvId
     */
    private Integer mainSpvId;


    /**
     * 通关方式（0：未知，1：BC，2：个人）
     */
    private Integer clearanceWay;


    /**
     * 商品属性(normal:普通，virtual：虚拟，logistics：大家具)
     */
    private String prodType;

    /**
     * 是否定制
     * 0:否，1：是
     */
    private Integer isCustomize;

    /**
     * 限量（0：无，1：折扣，6抢购）
     */
    private String limitType;

    /**
     * 计划发货日期
     */
    private Date planedDeliveryDate;

    /**
     * 包装（0，不需要，1纸袋包装)
     */
    private String casing;

    /**
     * 是否定制了卡片 0:否 1是
     */
    private Integer cardCustomized;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getPackageSkuId() {
        return packageSkuId;
    }

    public void setPackageSkuId(Integer packageSkuId) {
        this.packageSkuId = packageSkuId;
    }

    public Date getExpectReceiveDate() {
        return expectReceiveDate;
    }

    public void setExpectReceiveDate(Date expectReceiveDate) {
        this.expectReceiveDate = expectReceiveDate;
    }

    public String getLimitDeliveryTime() {
        return limitDeliveryTime;
    }

    public void setLimitDeliveryTime(String limitDeliveryTime) {
        this.limitDeliveryTime = limitDeliveryTime;
    }

    public String getMainSkuCode() {
        return mainSkuCode;
    }

    public void setMainSkuCode(String mainSkuCode) {
        this.mainSkuCode = mainSkuCode;
    }

    public Integer getMainSpvId() {
        return mainSpvId;
    }

    public void setMainSpvId(Integer mainSpvId) {
        this.mainSpvId = mainSpvId;
    }

    public Integer getClearanceWay() {
        return clearanceWay;
    }

    public void setClearanceWay(Integer clearanceWay) {
        this.clearanceWay = clearanceWay;
    }

    public String getProdType() {
        return prodType;
    }

    public void setProdType(String prodType) {
        this.prodType = prodType;
    }

    public Integer getIsCustomize() {
        return isCustomize;
    }

    public void setIsCustomize(Integer isCustomize) {
        this.isCustomize = isCustomize;
    }

    public String getLimitType() {
        return limitType;
    }

    public void setLimitType(String limitType) {
        this.limitType = limitType;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public String getCasing() {
        return casing;
    }

    public void setCasing(String casing) {
        this.casing = casing;
    }

    public Integer getCardCustomized() {
        return cardCustomized;
    }

    public void setCardCustomized(Integer cardCustomized) {
        this.cardCustomized = cardCustomized;
    }

    @Override
    public String toString() {
        return "SoPsPackageSkuInnerVO{" +
                "id=" + id +
                ", packageSkuId=" + packageSkuId +
                ", expectReceiveDate=" + expectReceiveDate +
                ", limitDeliveryTime='" + limitDeliveryTime + '\'' +
                ", mainSkuCode='" + mainSkuCode + '\'' +
                ", mainSpvId=" + mainSpvId +
                ", clearanceWay=" + clearanceWay +
                ", prodType='" + prodType + '\'' +
                ", isCustomize=" + isCustomize +
                ", limitType='" + limitType + '\'' +
                ", planedDeliveryDate=" + planedDeliveryDate +
                ", casing='" + casing + '\'' +
                ", cardCustomized=" + cardCustomized +
                '}';
    }
}
