package com.thebeastshop.salesorder.enums;

import com.google.common.collect.Lists;
import com.thebeastshop.common.utils.EnumUtil;

import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 18:14
 */
public enum SoPackageStatusEnum {

    PACKAGE_STATUS_UNSENT_CANCEL(-1, "未发货取消"),

    PACKAGE_STATUS_MAKE_HAND(2, "制单挂起"),

    PACKAGE_STATUS_DEFAULT_HAND(1, "初始挂起"),

    PACKAGE_STATUS_ALREADY_OUT(15, "已出库"),

    PACKAGE_STATUS_DEFAULT(10, "初始状态"),

    PACKAGE_STATUS_WAITING_MAKE(11, "待制单"),

    PACKAGE_STATUS_WAITING_SEND(12, "待发送"),

    PACKAGE_STATUS_WAITING_RECEIVE(13, "待收货"),

    PACKAGE_STATUS_ALREADY_RECEIVE(14, "已收货")

    ;

    private Integer id;

    private String name;

    SoPackageStatusEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static SoPackageStatusEnum getEnumById(Integer id) {
        for (SoPackageStatusEnum e : SoPackageStatusEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public static String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoPackageStatusEnum.class);
    }

    /**
     * 未制单状态
     */
    public static List<Integer> UN_MACK_STATUS = Lists.newArrayList(PACKAGE_STATUS_DEFAULT_HAND.id, PACKAGE_STATUS_MAKE_HAND.id, PACKAGE_STATUS_DEFAULT.id, PACKAGE_STATUS_WAITING_MAKE.id);


}
