package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;

/**
 * @author xiang.gao
 * @date 2025/5/14 14:50
 */
public enum SoOrderPickupStatusEnum {

    WAITNG(1, "待备货"),
    PREPARING(2, "备货中"),
    COMPLETED(3, "取货完成");

    private Integer id;

    private String name;


    SoOrderPickupStatusEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }


    public String getName() {
        return name;
    }


    public static String getStatusNameById(Integer id) {
        for (SoOrderPickupStatusEnum e : SoOrderPickupStatusEnum.values()) {
            if (e.getId().equals(id)) {
                return e.name;
            }
        }
        return null;
    }

    public static SoOrderPickupStatusEnum getEnumById(Integer id) {
        for (SoOrderPickupStatusEnum e : SoOrderPickupStatusEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoOrderPickupStatusEnum.class);
    }

}
