package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 17:47
 */
public enum SoOrderDownloadEnum {

    IS_NOT_EXPORT_OUT(0, "未导出"),
    IS_ALREADY_EXPORT_OUT(1, "已导出"),
    IS_ALREADY_EXPORT_IN(2, "已导入")

    ;

    private Integer id;

    private String name;

    SoOrderDownloadEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static SoOrderDownloadEnum getEnumById(Integer id) {
        for (SoOrderDownloadEnum e : SoOrderDownloadEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoOrderDownloadEnum.class);
    }


}
