package com.thebeastshop.salesorder.constant;

import com.google.common.collect.Lists;

import java.util.Arrays;
import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-03-07 17:10
 */
public class SoOrderConstant {

    // salesOrderType
    /**
     * 订单类型~渠道销售单
     */
    public static final int ORDER_TYPE_SALES = 1;
    /**
     * 订单类型~渠道换货单
     */
    public static final int ORDER_TYPE_EXCHANGE = 2;
    /**
     * 订单类型~集团订单
     */
    public static final int ORDER_TYPE_GROUP = 3;
    /**
     * 订单类型~渠道补货单
     */
    public static final int ORDER_TYPE_REPLENISH = 4;
    /**
     * 订单类型~礼品订单
     */
    public static final int ORDER_TYPE_GIFT = 11;
    /**
     * 订单类型~样品订单
     */
    public static final int ORDER_TYPE_SAMPLE = 12;

    /**
     * 订单类型~第三方订单
     */
    public static final int ORDER_TYPE_THIRD = 13;


    // salesOrderStatus
    /**
     * 订单状态~取消
     */
    public static final int ORDER_STATUS_CANCLE = 0;
    /**
     * 订单状态~未付款
     */
    public static final int ORDER_STATUS_NONPAYMENT = 1;
    /**
     * 订单状态~未付款挂起
     */
    public static final int ORDER_STATUS_HOLD = 2;
    /**
     * 订单状态~待审批
     */
    public static final int ORDER_STATUS_NOAUDIT = 3;
    /**
     * 订单状态~换货待收货
     */
    public static final int ORDER_STATUS_CHANGE_AFTER_RECEIVE = 5;
    /**
     * 订单状态~审单挂起
     */
    public static final int ORDER_STATUS_HOLD_REVIEW = 9;
    /**
     * 订单状态~待审单
     */
    public static final int ORDER_STATUS_WAITING_REVIEW = 10;
    /**
     * 订单状态~已审单
     */
    public static final int ORDER_STATUS_ALREADY_REVIEW = 11;
    /**
     * 订单状态~已完成
     */
    public static final int ORDER_STATUS_ALREADY_FINISHED = 12;

    /**
     * 匿名发送~是
     */
    public static final int IS_ANONYMOUS_TRUE = 1;
    /**
     * 匿名发送~否
     */
    public static final int IS_ANONYMOUS_FALSE = 0;

    /**
     * 需要发票~是
     */
    public static final int NEED_INVOICE_TRUE = 1;
    /**
     * 需要发票~否
     */
    public static final int NEED_INVOICE_FALSE = 0;

    // isInvoiceInSamePackage
    /**
     * 发票是否随同货物发送~是
     */
    public static final int IS_INVOICE_IN_SAME_PACKAGE_TRUE = 1;
    /**
     * 发票是否随同货物发送~否
     */
    public static final int IS_INVOICE_IN_SAME_PACKAGE_FALSE = 0;

    // isDownload
    /**
     * 导出状态~未导出
     */
    public static final int IS_DOWNLOAD_NOT_EXPORT_OUT = 0;
    /**
     * 导出状态~已导出
     */
    public static final int IS_DOWNLOAD_ALREADY_EXPORT_OUT = 1;
    /**
     * 导出状态~已导入
     */
    public static final int IS_DOWNLOAD_ALREADY_EXPORT_IN = 2;

    /**
     * 订单隐藏
     */
    public static final int ORDER_HIDE_TRUE = 1;

    /**
     * 订单不隐藏
     */
    public static final int ORDER_HIDE_FALSE = 0;
    /**
     * 海外购标志位-是海外购
     */
    public static final Integer CROSS_BOARDER_FLAG_IS_OVERSEA = 1;
    /**
     * 海外购标志位-不是海外购
     */
    public static final int CROSS_BOARDER_FLAG_NOT_OVERSEA = 0;

    /**
     * 月送鲜花
     */
    public static final int ORDER_TYPE_MONTHFLOWER = 1;
    
    /**
     * 拼团订单
     */
    public static final int ORDER_TYPE_GROUPON = 10;

    /**
     * 包裹状态~初始
     */
    public static final Integer PACKAGE_STATUS_DEFAULT = 10;

    /**
     * 预售状态~未转换
     */
    public static final Integer PRESALES_STATUS_WAIT = 1;

    /**
     * 未支付订单状态
     */
    public static final List<Integer> unPayStatusList = Lists.newArrayList(SoOrderConstant.ORDER_STATUS_NONPAYMENT, SoOrderConstant.ORDER_STATUS_HOLD);

    /**
     * 主站渠道
     */
    public static final List<String> CHANNEL_MAIN = Arrays.asList("CHN2049", "CHN2077", "CHN2018", "CHN2078");

    /**
     * 取件码渠道
     */
    public static final List<String> CHANNEL_PICKUP = Arrays.asList("CHN2078");

}
