package com.thebeastshop.salesorder.service;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.salesorder.vo.SoPackageDeliveryInfoVO;
import com.thebeastshop.salesorder.vo.pub.SoPsPackageDeliveryInfoVO;

import java.util.List;

/**
 * 订单包裹配送服务
 * @author xiang.gao
 * @date 2025/3/25 18:43
 */
public interface SoPackageDeliveryService {

    /**
     * 获取包裹的配送信息
     * @param packageId
     * @return
     */
    SoPsPackageDeliveryInfoVO getByPackageId(Long packageId);

    /**
     * 获取修改过的订单Id
     * @param orderIds
     * @return
     */
    List<Long> getModifiedOrderIdList(List<Long> orderIds);

    /**
     * 修改订单包裹配送信息
     * @param orderId
     * @param deliveryInfoVO
     * @return
     */
    ServiceResp modifyPackageDelivery(Long orderId, SoPackageDeliveryInfoVO deliveryInfoVO);

}
