/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;
import com.thebeastshop.payment.enums.PPaymentChannelEnum;
import com.thebeastshop.payment.enums.PPaymentChannelGroupEnum;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public enum SoPaymentTypeEnum {
    TYPE_UNKNOW(-1, "\u672a\u77e5"),
    CUSTOMER_SERVICE(0, "\u5ba2\u670d"),
    TYPE_CASH(1, "\u73b0\u91d1", PPaymentChannelGroupEnum.CASH, PPaymentChannelEnum.CASH),
    TYPE_CARD(2, "\u5237\u5361", PPaymentChannelGroupEnum.CREDIT_CARD, PPaymentChannelEnum.DEBIT_CARD, PPaymentChannelEnum.CREDIT_CARD),
    TYPE_WEIXIN(4, "\u5fae\u4fe1", PPaymentChannelGroupEnum.WXPAY, PPaymentChannelEnum.WEIXIN_MOBILE, PPaymentChannelEnum.WEIXIN_MINI_PROGRAM, PPaymentChannelEnum.WEIXIN_SCAN, PPaymentChannelEnum.WEIXIN_USER_SCAN, PPaymentChannelEnum.WEIXIN_OFFICIAL_ACCOUNT, PPaymentChannelEnum.WEIXIN_DIRECT),
    TYPE_ALIPAY(5, "\u652f\u4ed8\u5b9d", PPaymentChannelGroupEnum.ALIPAY, PPaymentChannelEnum.ALIPAY_MOBILE, PPaymentChannelEnum.ALI_CROSS_BORDER_MOBILE, PPaymentChannelEnum.ALIPAY_DIRECT, PPaymentChannelEnum.ALI_BANK, PPaymentChannelEnum.ALIPAY_SCAN, PPaymentChannelEnum.ALIPAY_USER_SCAN, PPaymentChannelEnum.ALI_CROSS_BORDER_DIRECT, PPaymentChannelEnum.ALIPAY_WAP_DIRECT, PPaymentChannelEnum.ALI_WAP_CROSS_BORDER_DIRECT),
    TYPE_CMB(6, "\u62db\u884c", PPaymentChannelGroupEnum.CMB, PPaymentChannelEnum.CMB),
    TYPE_TRANSFER(7, "\u8f6c\u8d26", PPaymentChannelGroupEnum.TRANSFER, PPaymentChannelEnum.TRANSFER),
    PRE_DEPOSIT(8, "\u9884\u5b58\u6b3e", PPaymentChannelGroupEnum.YCK, PPaymentChannelEnum.YCK),
    TYPE_PROPRIETOR(9, "\u4e1a\u4e3b", PPaymentChannelGroupEnum.YEZHU, PPaymentChannelEnum.YEZHU),
    TYPE_GIFT_CARD(10, "\u793c\u54c1\u5361", PPaymentChannelGroupEnum.GIFT_CARD, PPaymentChannelEnum.GIFT_CARD),
    TYPE_EXCHANGE(11, "\u79ef\u5206", PPaymentChannelGroupEnum.INTEGRAL, PPaymentChannelEnum.INTEGRAL),
    TYPE_CMB_CSSH(12, "\u62db\u884c\u638c\u4e0a\u751f\u6d3b", PPaymentChannelGroupEnum.CMB, PPaymentChannelEnum.CMB),
    TYPE_MARKET_COUPON(13, "\u5546\u573a\u5238", PPaymentChannelGroupEnum.MARKET_COUPON, PPaymentChannelEnum.MARKET_COUPON),
    TYPE_QUICK_PASS(14, "\u94f6\u8054\u4e91\u95ea\u4ed8", PPaymentChannelGroupEnum.QUICK_PASS_SCAN, PPaymentChannelEnum.QUICK_PASS_SCAN),
    TYPE_FUND(15, "\u57fa\u91d1", PPaymentChannelGroupEnum.FUND, PPaymentChannelEnum.FUND),
    TYPE_ELEME(16, "\u997f\u4e86\u4e48", PPaymentChannelGroupEnum.ELEME, PPaymentChannelEnum.ELEME),
    TYPE_TM_SHOPPING_FUND(17, "\u5929\u732b\u8d2d\u7269\u91d1", PPaymentChannelGroupEnum.TM_SHOPPING_FUND, PPaymentChannelEnum.TM_SHOPPING_FUND),
    TYPE_TM_INTERESTS_FUND(18, "\u5929\u732b\u6743\u76ca\u91d1", PPaymentChannelGroupEnum.TM_INTERESTS_FUND, PPaymentChannelEnum.TM_INTERESTS_FUND),
    SHOPPING_MALL_APP(19, "\u5546\u573a\u5c0f\u7a0b\u5e8f", PPaymentChannelGroupEnum.SHOPPING_MALL_APP, PPaymentChannelEnum.SHOPPING_MALL_APP),
    MARKETING_DISCOUNT(20, "\u5546\u5bb6\u652f\u4ed8\u8425\u9500\u4f18\u60e0", PPaymentChannelGroupEnum.MERCHANTS_PAY_MARKETING_DISCOUNT, PPaymentChannelEnum.MERCHANTS_PAY_MARKETING_DISCOUNT),
    GROUP_BUYING_VOUCHER(21, "\u56e2\u8d2d\u5238", PPaymentChannelGroupEnum.GROUP_BUYING_VOUCHER, PPaymentChannelEnum.GROUP_BUYING_VOUCHER),
    WORK_WEIXIN_TRANSFER(22, "\u4f01\u5fae\u8f6c\u8d26", PPaymentChannelGroupEnum.WORK_WEIXIN_TRANSFER, PPaymentChannelEnum.WORK_WEIXIN_TRANSFER);

    private Integer id;
    private String name;
    private PPaymentChannelGroupEnum refundChannelEnum;
    private List<PPaymentChannelEnum> paymentChannels;

    private SoPaymentTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    private SoPaymentTypeEnum(Integer id, String name, PPaymentChannelGroupEnum refundChannelEnum, PPaymentChannelEnum ... paymentChannels) {
        this.id = id;
        this.name = name;
        this.refundChannelEnum = refundChannelEnum;
        if (paymentChannels != null && paymentChannels.length > 0) {
            this.paymentChannels = Arrays.asList(paymentChannels);
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static SoPaymentTypeEnum getEnumById(Integer id) {
        for (SoPaymentTypeEnum e : SoPaymentTypeEnum.values()) {
            if (!e.getId().equals(id)) continue;
            return e;
        }
        return TYPE_UNKNOW;
    }

    public static String getNameById(Integer id) {
        return EnumUtil.getNameById((Integer)id, SoPaymentTypeEnum.class);
    }

    public PPaymentChannelGroupEnum getRefundChannelEnum() {
        return this.refundChannelEnum;
    }

    public List<PPaymentChannelEnum> getPaymentChannels() {
        return this.paymentChannels;
    }

    public static SoPaymentTypeEnum getByPaymentChannel(Integer paymentChannel) {
        for (SoPaymentTypeEnum soPaymentTypeEnum : SoPaymentTypeEnum.values()) {
            if (!CollectionUtils.isNotEmpty(soPaymentTypeEnum.getPaymentChannels())) continue;
            for (PPaymentChannelEnum channel : soPaymentTypeEnum.getPaymentChannels()) {
                if (!channel.getCode().equals(paymentChannel)) continue;
                return soPaymentTypeEnum;
            }
        }
        return TYPE_UNKNOW;
    }
}

