/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.salesorder.enums.SoPaymentTypeEnum;
import com.thebeastshop.salesorder.enums.SoRefundStatusEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

import org.apache.commons.lang3.StringUtils;

/**
 * @author Eric.Lou
 * @version $Id: OpReturnRefundVO.java, v 0.1 2015-08-27 15:32
 */
public class SoReturnRefundVO extends BaseDO {

    private static final long serialVersionUID = 1L;

	// constructor
    public SoReturnRefundVO() {

    }

    // original
    private Long       id;

    private Long       salesOrderId;

    private Integer       returnRequestId;
    
    private Integer       cutRequestId;
    
    private Integer    refundStatus;

    private BigDecimal refundAmount;

    private Date       createTime;

    private Date refundTime;

    private Long       operatorId;

    private String     operatorName;

    private Integer    refundType;

    private String     refundAccount;
    
    private String 	  refundReason;				// 退款原因

    private String     remark;
    // self
    private String     memberCode;

    private String     returnRequestCode;

    private String     salesOrderCode;

    private String     sourceOrderCode;

    private String    salesOrderChannelName;

    private String    salesOrderChannelCode;
    
    private BigDecimal aptGiftCardAmount;			// 礼品卡金额
    
    private String cardNum_Amount;					// 退礼品卡-金额对应数据（例：卡号_金额;卡号_金额）

    // manual generate
    public String getRefundStatusName() {
        if (refundStatus == null) return "";
        return SoRefundStatusEnum.getNameById(refundStatus);
    }

    public String getRefundTypeName() {
        if (refundType == null) return "";
        return SoPaymentTypeEnum.getNameById(refundType);
    }

    // auto negerate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSalesOrderId() {
        return salesOrderId;
    }

    public void setSalesOrderId(Long salesOrderId) {
        this.salesOrderId = salesOrderId;
    }



    public Integer getReturnRequestId() {
		return returnRequestId;
	}

	public void setReturnRequestId(Integer returnRequestId) {
		this.returnRequestId = returnRequestId;
	}

	public Integer getRefundStatus() {
        return refundStatus;
    }

    public void setRefundStatus(Integer refundStatus) {
        this.refundStatus = refundStatus;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getRefundTime() {
        return refundTime;
    }

    public void setRefundTime(Date refundTime) {
        this.refundTime = refundTime;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Integer getRefundType() {
        return refundType;
    }

    public void setRefundType(Integer refundType) {
        this.refundType = refundType;
    }

    public String getRefundAccount() {
        return refundAccount;
    }

    public void setRefundAccount(String refundAccount) {
        this.refundAccount = refundAccount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getReturnRequestCode() {
        return returnRequestCode;
    }

    public void setReturnRequestCode(String returnRequestCode) {
        this.returnRequestCode = returnRequestCode;
    }

    public String getSalesOrderCode() {
        return salesOrderCode;
    }

    public void setSalesOrderCode(String salesOrderCode) {
        this.salesOrderCode = salesOrderCode;
    }

    public String getSourceOrderCode() {
        return sourceOrderCode;
    }

    public void setSourceOrderCode(String sourceOrderCode) {
        this.sourceOrderCode = sourceOrderCode;
    }

    public String getSalesOrderChannelName() {
        return salesOrderChannelName;
    }

    public void setSalesOrderChannelName(String salesOrderChannelName) {
        this.salesOrderChannelName = salesOrderChannelName;
    }

    public String getSalesOrderChannelCode() {
        return salesOrderChannelCode;
    }

    public void setSalesOrderChannelCode(String salesOrderChannelCode) {
        this.salesOrderChannelCode = salesOrderChannelCode;
    }

    public String getRefundReason() {
		return refundReason;
	}
	public void setRefundReason(String refundReason) {
		this.refundReason = refundReason;
	}

    public BigDecimal getAptGiftCardAmount() {
		return aptGiftCardAmount;
	}

	public void setAptGiftCardAmount(BigDecimal aptGiftCardAmount) {
		this.aptGiftCardAmount = aptGiftCardAmount;
	}

	public String getCardNum_Amount() {
		return cardNum_Amount;
	}
	public void setCardNum_Amount(String cardNum_Amount) {
		this.cardNum_Amount = cardNum_Amount;
	}

	public Integer getCutRequestId() {
		return cutRequestId;
	}

	public void setCutRequestId(Integer cutRequestId) {
		this.cutRequestId = cutRequestId;
	}

	public List<Map<String,Object>> getCardNum_AmountList(){
		List<Map<String,Object>> list= new ArrayList<>();
		if(!StringUtils.isBlank(cardNum_Amount)){
			String arr[] =  cardNum_Amount.split(";");
			if(arr != null && arr.length > 0){
				for(String str : arr){
					String cardNum_AmountSrr[] = str.split("_");
					if(cardNum_AmountSrr.length == 2){
						Map<String,Object> map = new HashMap<String,Object>();
						map.put("cardNum", cardNum_AmountSrr[0]);
						map.put("amount", cardNum_AmountSrr[1]);
						list.add(map);
					}
				}
			}
		}

		return list;
	}
}
