package com.thebeastshop.salesorder.vo;

import java.io.Serializable;

/**
 * @ClassName: SoPackageSkuCardVO
 * @Description: 订单商品行定制卡片
 * @author: Xiang.Gao
 * @date: 2020/11/10 15:14
 */
public class SoPackageSkuCardVO implements Serializable {

    private static final long serialVersionUID = -1502658380540826583L;

    /**
     * 卡片类型，1空白2代写
     */
    private Integer type;

    /**
     * 卡片抬头信息
     */
    private String to;

    /**
     * 卡片正文
     */
    private String content;

    /**
     * 卡片落款信息
     */
    private String from;

    /**
     * 日期（一个普通的展示字段，无业务意义）
     */
    private String date;

    /**
     * 标签（一个普通的展示字段，无业务意义）
     */
    private String label;

    /**
     * 数量
     */
    private Integer count = 0;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTo() {
        return to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    @Override
    public String toString() {
        return "SoPackageSkuCardVO{" +
                "type=" + type +
                ", to='" + to + '\'' +
                ", content='" + content + '\'' +
                ", from='" + from + '\'' +
                ", date=" + date +
                ", label=" + label +
                ", count=" + count +
                '}';
    }
}
