/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo;


import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.salesorder.enums.SoPackageStatusEnum;

import java.util.Date;

/**
 * @author Eric.Lou
 * @version $Id: DispatchedPackageVO.java, v 0.1 2015-12-25 11:02
 */
public class SoDispatchedPackageVO extends BaseDO {

    // constrcutor
    public SoDispatchedPackageVO(){}

    // self
    private String channelName;
    private String packageCode;
    private Integer packageStatus;
    private String dispatchWarehouseCode;
    private Date expectReceiveDate;
    private Date planedDeliveryDate;
    private String deliveryCode;

    // manual generate
    public String getPackageStatusName() {
        return SoPackageStatusEnum.getNameById(packageStatus);
    }

/*
    pub String getDispatchWarehouseName() {
        String name = "";
        if (NullUtil.isNotNull(dispatchWarehouseCode)) {
            WhWarehouse wh = PegasusWarehouseServiceFacade.getInstance().findWarehouseByCode(dispatchWarehouseCode);
            if (NullUtil.isNotNull(wh) && EmptyUtil.isNotEmpty(wh.getName())) {
                name = wh.getName();
            }
        }
        return name;
    }
*/
    // auto generate
    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getPackageCode() {
        return packageCode;
    }

    public void setPackageCode(String packageCode) {
        this.packageCode = packageCode;
    }

    public Integer getPackageStatus() {
        return packageStatus;
    }

    public void setPackageStatus(Integer packageStatus) {
        this.packageStatus = packageStatus;
    }

    public String getDispatchWarehouseCode() {
        return dispatchWarehouseCode;
    }

    public void setDispatchWarehouseCode(String dispatchWarehouseCode) {
        this.dispatchWarehouseCode = dispatchWarehouseCode;
    }

    public Date getExpectReceiveDate() {
        return expectReceiveDate;
    }

    public void setExpectReceiveDate(Date expectReceiveDate) {
        this.expectReceiveDate = expectReceiveDate;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

}
