package com.thebeastshop.salesorder.service;

import java.util.List;

import com.thebeastshop.salesorder.vo.snapshoot.OrderPriceSkuVO;
import com.thebeastshop.salesorder.vo.snapshoot.OrderPriceVO;
import com.thebeastshop.salesorder.vo.snapshoot.OrderStepVO;

/**
 * 订单快照
 * 
 * @author wyw
 * @since 2018-10-11
 */
public interface OrderPriceService {

	/**
	 * 根据价格步骤创建订单快照
	 * 
	 * @param steps
	 * @return
	 */

	Boolean createSnapShoot(OrderStepVO steps);

	/**
	 * 价格步骤查询
	 * 
	 * @param orderId
	 * @return
	 */

	List<OrderPriceVO> getOrderPriceList(Long orderId);

	/**
	 * 订单商品价格查询
	 * 
	 * @param orderId
	 * @return
	 */

	List<OrderPriceSkuVO> getOrderPriceSkuList(Long orderId);

	/**
	 * 订单商品价格查询
	 * 
	 * @param orderId，spvId
	 * @return
	 */

	List<OrderPriceSkuVO> getOrderPriceSkuListBySpvId(Long orderId, Long spvId);

}
