package com.thebeastshop.salesorder.vo.thirdparty;


import com.thebeastshop.common.BaseDO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/***
 * 处理接口请求的订单对象. 下单接口对象
 * @author ztq
 *
 */
public class SoThirdpartyOrderCreateVO extends BaseDO {

	//是否匿名购买
	private Boolean anonymous;
	// 礼品卡金额
	private Double cardFeeDiscount;

	private String channelCode;

	//优惠券
	private String couponCode;
	//购买者id
	private Long customerId;
	//收货人信息
	private SoThridpartyAddressVO deliveryAddress=new SoThridpartyAddressVO();
	//送达日期
	private String deliveryDate;
	//预计发货日期
	private Date preDeliveryDate;
	//配送方式
	private Integer deliveryType;
	//配送方式名称
	private String deliveryTypeName;
	// 内部备注
	private String innerRemark;
	//订单详情
	private List<SoThirdpartyOrderCreateDetailVO> items=new ArrayList<SoThirdpartyOrderCreateDetailVO>();
	//是否限时配送
	private Boolean limitedDelivery;
	//显示配送时间
	private String limitedHour;
	//买家备注信息
	private String note;
	//卡片
	private Integer noteCard;
	//卡片内容
	private String noteCardMessage;
	//折扣费用
	private Double otherDiscount;
	//外部订单号(针对第三方渠道)
	private String outerOrderCode;
	//提货门店id --对应自提
	private String pickShopId;
	//礼品卡
	private String presentCards;
	//订单外部来源
	private String refer;
	//服务费
	private Double serviceFee;
	
	//买家昵称（天猫）
	private String buyerNick;
	
	//包裹备注
	private String packageRemark;
	
	//第三方订单号
	private String thirdpartyOrderCode;
	


	/**
	 * @author lijing
	 * 是否需要发票  0否 1 是
	 */
	
	private Integer needInvoice;
	
	
	private String needInvoiceCN;

	/**
	 * @author lijing
	 * 发票是否随同货物发送，0否1是
	 */
	private Integer isInvoiceInSamePackage;
	
	private Integer isInvoiceInSamePackageCN;


	/**
	 * 发票
	 */
	private SoThirdpartyInvoiceInfoVO soInvoiceInfoVO = new SoThirdpartyInvoiceInfoVO();
	
	
	   /**
     * 需要发票~是
     */
    public static final Integer NEED_INVOICE_TRUE = 1;
    /**
     * 需要发票~否
     */
    public static final Integer NEED_INVOICE_FALSE = 0;
    
	//  跨境购标注 0普通１跨境购
	private Integer crossBorderFlag; 
	// 海淘运费
    private BigDecimal crossFree;
	//退款状态：可选值 WAIT_SELLER_AGREE(买家已经申请退款，等待卖家同意) 
	//WAIT_BUYER_RETURN_GOODS(卖家已经同意退款，等待买家退货) 
	//WAIT_SELLER_CONFIRM_GOODS(买家已经退货，等待卖家确认收货) 
	//SELLER_REFUSE_BUYER(卖家拒绝退款) CLOSED(退款关闭) SUCCESS(退款成功)
	private String refundStatus;
	
	
	private int expressType;
    
	//天猫订单来源（JHS等）
    private String tradeFrom;

	private Date payTime;

	public Date getPayTime() {
		return payTime;
	}

	public void setPayTime(Date payTime) {
		this.payTime = payTime;
	}

	public String getPackageRemark() {
		return packageRemark;
	}

	public void setPackageRemark(String packageRemark) {
		this.packageRemark = packageRemark;
	}
    
	public String getTradeFrom() {
		return tradeFrom;
	}

	public void setTradeFrom(String tradeFrom) {
		this.tradeFrom = tradeFrom;
	}

	public int getExpressType() {
		return expressType;
	}

	public void setExpressType(int expressType) {
		this.expressType = expressType;
	}

	public String getRefundStatus() {
		return refundStatus;
	}

	public void setRefundStatus(String refundStatus) {
		this.refundStatus = refundStatus;
	}
	
	public String getBuyerNick() {
		return buyerNick;
	}


	public Date getPreDeliveryDate() {
		return preDeliveryDate;
	}

	public void setPreDeliveryDate(Date preDeliveryDate) {
		this.preDeliveryDate = preDeliveryDate;
	}

	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public Boolean getAnonymous() {
		return anonymous;
	}

	public Double getCardFeeDiscount() {
		return cardFeeDiscount;
	}

	public String getChannelCode() {
		return channelCode;
	}

	public String getCouponCode() {
		return couponCode;
	}
	
	
	public Long getCustomerId() {
		return customerId;
	}

	public SoThridpartyAddressVO getDeliveryAddress() {
		return deliveryAddress;
	}

	public String getDeliveryDate() {
		return deliveryDate;
	}

	public Integer getDeliveryType() {
		return deliveryType;
	}

	public String getInnerRemark() {
		return innerRemark;
	}

	public List<SoThirdpartyOrderCreateDetailVO> getItems() {
		return items;
	}

	public Boolean getLimitedDelivery() {
		return limitedDelivery;
	}

	public String getLimitedHour() {
		return limitedHour;
	}

	public String getNote() {
		return note;
	}

	public Integer getNoteCard() {
		return noteCard;
	}

	public String getNoteCardMessage() {
		return noteCardMessage;
	}

	public Double getOtherDiscount() {
		return otherDiscount;
	}

	public String getOuterOrderCode() {
		return outerOrderCode;
	}

	public String getPickShopId() {
		return pickShopId;
	}

	public String getPresentCards() {
		return presentCards;
	}

	public String getRefer() {
		return refer;
	}

	public Double getServiceFee() {
		return serviceFee;
	}

	public void setAnonymous(Boolean anonymous) {
		this.anonymous = anonymous;
	}

	public void setCardFeeDiscount(Double cardFeeDiscount) {
		this.cardFeeDiscount = cardFeeDiscount;
	}

	public void setChannelCode(String channelCode) {
		this.channelCode = channelCode;
	}

	public void setCouponCode(String couponCode) {
		this.couponCode = couponCode;
	}

	public void setCustomerId(Long customerId) {
		this.customerId = customerId;
	}

	public void setDeliveryAddress(SoThridpartyAddressVO deliveryAddress) {
		this.deliveryAddress = deliveryAddress;
	}

	public void setDeliveryDate(String deliveryDate) {
		this.deliveryDate = deliveryDate;
	}

	public void setDeliveryType(Integer deliveryType) {
		this.deliveryType = deliveryType;
	}

	public void setInnerRemark(String innerRemark) {
		this.innerRemark = innerRemark;
	}

	public void setItems(List<SoThirdpartyOrderCreateDetailVO> items) {
		this.items = items;
	}

	public void setLimitedDelivery(Boolean limitedDelivery) {
		this.limitedDelivery = limitedDelivery;
	}

	public void setLimitedHour(String limitedHour) {
		this.limitedHour = limitedHour;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public void setNoteCard(Integer noteCard) {
		this.noteCard = noteCard;
	}

	public void setNoteCardMessage(String noteCardMessage) {
		this.noteCardMessage = noteCardMessage;
	}

	public void setOtherDiscount(Double otherDiscount) {
		this.otherDiscount = otherDiscount;
	}

	public void setOuterOrderCode(String outerOrderCode) {
		this.outerOrderCode = outerOrderCode;
	}

	public void setPickShopId(String pickShopId) {
		this.pickShopId = pickShopId;
	}

	public void setPresentCards(String presentCards) {
		this.presentCards = presentCards;
	}

	public void setRefer(String refer) {
		this.refer = refer;
	}

	public void setServiceFee(Double serviceFee) {
		this.serviceFee = serviceFee;
	}

	public Integer getNeedInvoice() {
		return needInvoice;
	}

	public void setNeedInvoice(Integer needInvoice) {
		this.needInvoice = needInvoice;
	}

	public Integer getIsInvoiceInSamePackage() {
		return isInvoiceInSamePackage;
	}

	public void setIsInvoiceInSamePackage(Integer isInvoiceInSamePackage) {
		this.isInvoiceInSamePackage = isInvoiceInSamePackage;
	}

	public SoThirdpartyInvoiceInfoVO getSoInvoiceInfoVO() {
		return soInvoiceInfoVO;
	}

	public void setSoInvoiceInfoVO(SoThirdpartyInvoiceInfoVO soInvoiceInfoVO) {
		this.soInvoiceInfoVO = soInvoiceInfoVO;
	}

	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}

	public BigDecimal getCrossFree() {
		return crossFree;
	}

	public void setCrossFree(BigDecimal crossFree) {
		this.crossFree = crossFree;
	}

	public String getThirdpartyOrderCode() {
		return thirdpartyOrderCode;
	}

	public void setThirdpartyOrderCode(String thirdpartyOrderCode) {
		this.thirdpartyOrderCode = thirdpartyOrderCode;
	}

	public String getDeliveryTypeName() {
		return deliveryTypeName;
	}

	public void setDeliveryTypeName(String deliveryTypeName) {
		this.deliveryTypeName = deliveryTypeName;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((channelCode == null) ? 0 : channelCode.hashCode());
		result = prime * result + ((outerOrderCode == null) ? 0 : outerOrderCode.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SoThirdpartyOrderCreateVO other = (SoThirdpartyOrderCreateVO) obj;
		if (channelCode == null) {
			if (other.channelCode != null)
				return false;
		} else if (!channelCode.equals(other.channelCode))
			return false;
		if (outerOrderCode == null) {
			if (other.outerOrderCode != null)
				return false;
		} else if (!outerOrderCode.equals(other.outerOrderCode))
			return false;
		return true;
	}

	
	
	
	
}
