package com.thebeastshop.salesorder.vo.pub;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.salesorder.dto.SoThirdChannelCPSDto;
import com.thebeastshop.salesorder.vo.SoWhAllotRcdVO;

/***
 * 订单VO
 *
 * @author fs
 */
public class SoPsOrderVO extends BaseDO {

	
    private String address;

    private Long addressId;

    //审单时间
    private Date auditTime;

    //订单来源渠道编码
    private String channelCode;
    private String circuitDesc;
    private String city;
    private String code;

    //COUPON编码
    private String couponCode;

    private BigDecimal couponFee;

    //coupon折扣总额
    private BigDecimal couponDiscountAmount = BigDecimal.ZERO;

    //操作员Id
    private Long createOperatorId;

    //操作员名称
    private String createOperatorName;

    private Date createTime;

    private String district;

    // 期望收货日期
    private Date expectReceiveDate;

    //食品特殊备注
    private String foodSpecific;
    //礼品卡支付金额
    private BigDecimal giftCardAmount = BigDecimal.ZERO;
    //礼品卡卡号,逗号分隔
    private String giftCardDesc;
    //集团订单关联的合同号，null表示非集团订单
    private String groupContractCode;

    private Long id;
    //内部备注
    private String innerRemark;
    //是否匿名发货 0否1是
    private Integer isAnonymous;
    //是否强制审单
    private Integer isForceAudit;
    //发票是否随同货物发送，0否1是
    private Integer isInvoiceInSamePackage;

    private String limitDeliveryTimeDesc;

    //会员编码
    private String memberCode;
    //会员id
    private Long memberId;
    //是否需要发票 0否1是
    private Integer needInvoice;
    //需要支付的总金额
    private BigDecimal needToPayAmount = BigDecimal.ZERO;
    private List<SoPsPackageSkuVO> soPsPackageSkuVOs = new ArrayList<>();
    //订单对应的包裹列表
    private List<SoPsPackageVO> soPsPackageVOs = new ArrayList<>();
    //外部订单号
    private String outerOrderCode;
    //支付方式，1现金2借记卡3信用卡4微信5支付宝6招行
    private Integer paymentType;
    //支付时间
    private Date payTime;
    
	/**
	 * 支付流水号
	 */
	private String tradeNo;
    
    // 预计发货日期
    private Date planedDeliveryDate;
    //头积分
    private BigDecimal pointOnHead = BigDecimal.ZERO;
    private BigDecimal pointOnLine = BigDecimal.ZERO;
    //头积分抵扣金额
    private BigDecimal pointOnHeadDeduction= BigDecimal.ZERO;
    private BigDecimal priceUnit= BigDecimal.ZERO;
    private String province;
    //数量
    private Integer quantity;
    private String Receiver;
    private String receiverPhone;
    //订单来源 推广来源
    private String refer;

    //用户备注
    private String remark;
    private Integer salesOrderStatus;
    //订单类型，1渠道销售单2渠道换货单3集团订单11礼品订单12样品订单
    private Integer salesOrderType;
    //服务费
    private BigDecimal serviceFeeAmount= BigDecimal.ZERO;
    private Integer shopId;
    private String shopName;

    // sku
    private String skuCode;
    //原订单号，渠道退货、换货时记录
    private String sourceSoCode;
    private String street;
    //总金额
	/**
	 * 总价
	 */
	private BigDecimal totalAmount=BigDecimal.ZERO;
	/**
	 * 订单头折扣
	 */
	private BigDecimal discountOnHead=BigDecimal.ZERO;
	/**
	 * 订单行折扣汇总
	 */
	private BigDecimal discountOnLine=BigDecimal.ZERO;

    //
    private BigDecimal totalAmountAfterDiscount = BigDecimal.ZERO;
    private String zipCode;

    private Integer hideFlag;

    private String buyerNick;
   /**第三方渠道*/
    private SoThirdChannelCPSDto thirdChannelCPS;
    /**
     * 发票
     */
    private SoPsInvoiceInfoVO soInvoiceInfoVO;

    //对应的预售调拨列表 买赠时主品是预售，从销售仓调拨赠品到预售仓
    List<SoWhAllotRcdVO> whAllotList;

    /**
     * 身份证信息
     */
    private SoPsIdCardVO opIdCardVO;

    // 跨境购标注 0普通１跨境购
    private Integer crossBorderFlag;
    // 海淘运输费用 FIXME:费用=fee，不是free
    private BigDecimal crossFree = BigDecimal.ZERO;

	private BigDecimal actualPayFee= BigDecimal.ZERO;

	//第三方订单号
	private String thirdpartyOrderCode;

	// APP下载来源
	private String downloadSource;

    private Map<String, String> categoryCodeMap = new HashMap<>();

    /**
     * 1月送鲜花订单
     */
    private Integer orderType = 0;
    
    /**
	 * 限时送达费用
	 */
	private BigDecimal limitFeeAmount=BigDecimal.ZERO;
	/**
	 * 运费
	 */
	private BigDecimal carriageAmount=BigDecimal.ZERO;
	
  	/**
  	 * 生日折扣
  	 */
  	private BigDecimal birthdayDiscountAmount=BigDecimal.ZERO;

	/**
	 * 权益Id
	 */
	private String interestsId;
	
	/**
	 * 定制费
	 */
	private BigDecimal customizationAmount= BigDecimal.ZERO;
	/**
	 * 定制折扣
	 */
	private BigDecimal customizationDiscount= BigDecimal.ZERO;
	/**
	 * 设备Id
	 */
	private String deviceId;

	/**
	 * 投放来源
	 */
	private String utmSource;

	/**
	 * 预存款
	 */
    private BigDecimal accountPayAmount = BigDecimal.ZERO;
    
    /**
     * 总支付金额
     */
    private BigDecimal totalNeedToPayAmount = BigDecimal.ZERO;

    /**
     * 基金返还金额
     */
    private BigDecimal fundReturnAmount = BigDecimal.ZERO;

    /**
     * 基金支付金额
     */
    private BigDecimal fundPayAmount = BigDecimal.ZERO;
    
    /**
     * 第三方订单
     */
    private List<String> thirdpartyOrderCodes = new ArrayList<>();
	
    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public String getDownloadSource() {
		return downloadSource;
	}

	public void setDownloadSource(String downloadSource) {
		this.downloadSource = downloadSource;
	}

	public String getThirdpartyOrderCode() {
		return thirdpartyOrderCode;
	}

	public void setThirdpartyOrderCode(String thirdpartyOrderCode) {
		this.thirdpartyOrderCode = thirdpartyOrderCode;
	}

	/**
     * 生日优惠折扣
     */
    private BigDecimal birthdayDiscount=BigDecimal.ZERO;
    public String getAddress() {
        return address;
    }

    public Long getAddressId() {
        return addressId;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public String getBuyerNick() {
        return buyerNick;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public String getCircuitDesc() {
        return circuitDesc;
    }

    public String getCity() {
        return city;
    }

    public String getCode() {
        return code;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public BigDecimal getCouponDiscountAmount() {
        return couponDiscountAmount;
    }

    public Long getCreateOperatorId() {
        return createOperatorId;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public BigDecimal getDiscountOnHead() {
        return discountOnHead;
    }

    public String getDistrict() {
        return district;
    }

    public Date getExpectReceiveDate() {
        return expectReceiveDate;
    }

    public String getFoodSpecific() {
        return foodSpecific;
    }

    public BigDecimal getGiftCardAmount() {
        return giftCardAmount;
    }

    public String getGiftCardDesc() {
        return giftCardDesc;
    }

    public String getGroupContractCode() {
        return groupContractCode;
    }

    public Integer getHideFlag() {
        return hideFlag;
    }

    public Long getId() {
        return id;
    }

    public String getInnerRemark() {
        return innerRemark;
    }

    public Integer getIsAnonymous() {
        return isAnonymous;
    }

    public Integer getIsForceAudit() {
        return isForceAudit;
    }

    public Integer getIsInvoiceInSamePackage() {
        return isInvoiceInSamePackage;
    }

    public String getLimitDeliveryTimeDesc() {
        return limitDeliveryTimeDesc;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public Long getMemberId() {
        return memberId;
    }

    public Integer getNeedInvoice() {
        return needInvoice;
    }

    public BigDecimal getNeedToPayAmount() {
        return needToPayAmount;
    }

    public List<SoPsPackageSkuVO> getSoPsPackageSkuVOs() {
        return soPsPackageSkuVOs;
    }

    public List<SoPsPackageVO> getSoPsPackageVOs() {
        return soPsPackageVOs;
    }

    public String getOuterOrderCode() {
        return outerOrderCode;
    }

    public Integer getPaymentType() {
        return paymentType;
    }

    public Date getPayTime() {
        return payTime;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public BigDecimal getPointOnHead() {
        return pointOnHead;
    }

    public BigDecimal getPointOnHeadDeduction() {
        return pointOnHeadDeduction;
    }

    public BigDecimal getPriceUnit() {
        return priceUnit;
    }

    public String getProvince() {
        return province;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public String getReceiver() {
        return Receiver;
    }

    public String getReceiverPhone() {
        return receiverPhone;
    }

    public String getRefer() {
        return refer;
    }

    public String getRemark() {
        return remark;
    }

    public Integer getSalesOrderStatus() {
        return salesOrderStatus;
    }

    public Integer getSalesOrderType() {
        return salesOrderType;
    }

    public BigDecimal getServiceFeeAmount() {
        return serviceFeeAmount;
    }

    public Integer getShopId() {
        return shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public SoPsInvoiceInfoVO getSoInvoiceInfoVO() {
        return soInvoiceInfoVO;
    }

    public String getSourceSoCode() {
        return sourceSoCode;
    }

    public String getStreet() {
        return street;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public BigDecimal getTotalAmountAfterDiscount() {
        return totalAmountAfterDiscount;
    }

    public List<SoWhAllotRcdVO> getWhAllotList() {
        return whAllotList;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setAddress(final String address) {
        this.address = address;
    }

    public void setAddressId(final Long addressId) {
        this.addressId = addressId;
    }

    public void setAuditTime(final Date auditTime) {
        this.auditTime = auditTime;
    }

    public void setBuyerNick(final String buyerNick) {
        this.buyerNick = buyerNick;
    }

    public void setChannelCode(final String channelCode) {
        this.channelCode = channelCode;
    }

    public void setCircuitDesc(final String circuitDesc) {
        this.circuitDesc = circuitDesc;
    }

    public void setCity(final String city) {
        this.city = city;
    }

    public void setCode(final String code) {
        this.code = code;
    }

    public void setCouponCode(final String couponCode) {
        this.couponCode = couponCode;
    }

    public void setCouponDiscountAmount(final BigDecimal couponDiscountAmount) {
        this.couponDiscountAmount = couponDiscountAmount;
    }

    public void setCreateOperatorId(final Long createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public void setCreateOperatorName(final String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public void setCreateTime(final Date createTime) {
        this.createTime = createTime;
    }

    public void setDiscountOnHead(final BigDecimal discountOnHead) {
        this.discountOnHead = discountOnHead;
    }

    public void setDistrict(final String district) {
        this.district = district;
    }

    public void setExpectReceiveDate(final Date expectReceiveDate) {
        this.expectReceiveDate = expectReceiveDate;
    }

    public void setFoodSpecific(final String foodSpecific) {
        this.foodSpecific = foodSpecific;
    }

    public void setGiftCardAmount(final BigDecimal giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
    }

    public void setGiftCardDesc(final String giftCardDesc) {
        this.giftCardDesc = giftCardDesc;
    }

    public void setGroupContractCode(final String groupContractCode) {
        this.groupContractCode = groupContractCode;
    }

    public void setHideFlag(final Integer hideFlag) {
        this.hideFlag = hideFlag;
    }

    public void setId(final Long id) {
        this.id = id;
    }

    public void setInnerRemark(final String innerRemark) {
        this.innerRemark = innerRemark;
    }

    public void setIsAnonymous(final Integer isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public void setIsForceAudit(final Integer isForceAudit) {
        this.isForceAudit = isForceAudit;
    }

    public void setIsInvoiceInSamePackage(final Integer isInvoiceInSamePackage) {
        this.isInvoiceInSamePackage = isInvoiceInSamePackage;
    }

    public void setLimitDeliveryTimeDesc(final String limitDeliveryTimeDesc) {
        this.limitDeliveryTimeDesc = limitDeliveryTimeDesc;
    }

    public void setMemberCode(final String memberCode) {
        this.memberCode = memberCode;
    }

    public void setMemberId(final Long memberId) {
        this.memberId = memberId;
    }

    public void setNeedInvoice(final Integer needInvoice) {
        this.needInvoice = needInvoice;
    }

    public void setNeedToPayAmount(final BigDecimal needToPayAmount) {
        this.needToPayAmount = needToPayAmount;
    }

    public void setSoPsPackageSkuVOs(final List<SoPsPackageSkuVO> soPsPackageSkuVOs) {
        this.soPsPackageSkuVOs = soPsPackageSkuVOs;
    }

    public void setSoPsPackageVOs(final List<SoPsPackageVO> soPsPackageVOs) {
        this.soPsPackageVOs = soPsPackageVOs;
    }

    public void setOuterOrderCode(final String outerOrderCode) {
        this.outerOrderCode = outerOrderCode;
    }

    public void setPaymentType(final Integer paymentType) {
        this.paymentType = paymentType;
    }

    public void setPayTime(final Date payTime) {
        this.payTime = payTime;
    }

    public void setPlanedDeliveryDate(final Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public void setPointOnHead(final BigDecimal pointOnHead) {
        this.pointOnHead = pointOnHead;
    }

    public void setPointOnHeadDeduction(final BigDecimal pointOnHeadDeduction) {
        this.pointOnHeadDeduction = pointOnHeadDeduction;
    }

    public void setPriceUnit(final BigDecimal priceUnit) {
        this.priceUnit = priceUnit;
    }

    public void setProvince(final String province) {
        this.province = province;
    }

    public void setQuantity(final Integer quantity) {
        this.quantity = quantity;
    }

    public void setReceiver(final String receiver) {
        Receiver = receiver;
    }

    public void setReceiverPhone(final String receiverPhone) {
        this.receiverPhone = receiverPhone;
    }

    public void setRefer(final String refer) {
        this.refer = refer;
    }

    public void setRemark(final String remark) {
        this.remark = remark;
    }

    public void setSalesOrderStatus(final Integer salesOrderStatus) {
        this.salesOrderStatus = salesOrderStatus;
    }

    public void setSalesOrderType(final Integer salesOrderType) {
        this.salesOrderType = salesOrderType;
    }

    public void setServiceFeeAmount(final BigDecimal serviceFeeAmount) {
        this.serviceFeeAmount = serviceFeeAmount;
    }

    public void setShopId(final Integer shopId) {
        this.shopId = shopId;
    }

    public void setShopName(final String shopName) {
        this.shopName = shopName;
    }

    public void setSkuCode(final String skuCode) {
        this.skuCode = skuCode;
    }

    public void setSoInvoiceInfoVO(final SoPsInvoiceInfoVO soInvoiceInfoVO) {
        this.soInvoiceInfoVO = soInvoiceInfoVO;
    }

    public void setSourceSoCode(final String sourceSoCode) {
        this.sourceSoCode = sourceSoCode;
    }

    public void setStreet(final String street) {
        this.street = street;
    }

    public void setTotalAmount(final BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setTotalAmountAfterDiscount(final BigDecimal totalAmountAfterDiscount) {
        this.totalAmountAfterDiscount = totalAmountAfterDiscount;
    }

    public void setWhAllotList(final List<SoWhAllotRcdVO> whAllotList) {
        this.whAllotList = whAllotList;
    }

    public void setZipCode(final String zipCode) {
        this.zipCode = zipCode;
    }

    public SoPsIdCardVO getOpIdCardVO() {
        return opIdCardVO;
    }

    public void setOpIdCardVO(final SoPsIdCardVO opIdCardVO) {
        this.opIdCardVO = opIdCardVO;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(final Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public BigDecimal getCrossFree() {
        return crossFree;
    }

    public void setCrossFree(final BigDecimal crossFree) {
        this.crossFree = crossFree;
    }

	public BigDecimal getDiscountOnLine() {
		return discountOnLine;
	}

	public void setDiscountOnLine(BigDecimal discountOnLine) {
		this.discountOnLine = discountOnLine;
	}

	public BigDecimal getCouponFee() {
		return couponFee;
	}

	public void setCouponFee(BigDecimal couponFee) {
		this.couponFee = couponFee;
	}

	public BigDecimal getBirthdayDiscount() {
		return birthdayDiscount;
	}

	public void setBirthdayDiscount(BigDecimal birthdayDiscount) {
		this.birthdayDiscount = birthdayDiscount;
	}

	public BigDecimal getActualPayFee() {
		return actualPayFee;
	}

	public void setActualPayFee(BigDecimal actualPayFee) {
		this.actualPayFee = actualPayFee;
	}

    public SoThirdChannelCPSDto getThirdChannelCPS() {
        return thirdChannelCPS;
    }

    public void setThirdChannelCPS(SoThirdChannelCPSDto thirdChannelCPS) {
        this.thirdChannelCPS = thirdChannelCPS;
    }

    public Map<String, String> getCategoryCodeMap() {
        return categoryCodeMap;
    }

    public void setCategoryCodeMap(Map<String, String> categoryCodeMap) {
        this.categoryCodeMap = categoryCodeMap;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("address", address)
                .append("addressId", addressId)
                .append("auditTime", auditTime)
                .append("channelCode", channelCode)
                .append("circuitDesc", circuitDesc)
                .append("city", city)
                .append("code", code)
                .append("couponCode", couponCode)
                .append("couponFee", couponFee)
                .append("couponDiscountAmount", couponDiscountAmount)
                .append("createOperatorId", createOperatorId)
                .append("createOperatorName", createOperatorName)
                .append("createTime", createTime)
                .append("district", district)
                .append("expectReceiveDate", expectReceiveDate)
                .append("foodSpecific", foodSpecific)
                .append("giftCardAmount", giftCardAmount)
                .append("giftCardDesc", giftCardDesc)
                .append("groupContractCode", groupContractCode)
                .append("id", id)
                .append("innerRemark", innerRemark)
                .append("isAnonymous", isAnonymous)
                .append("isForceAudit", isForceAudit)
                .append("isInvoiceInSamePackage", isInvoiceInSamePackage)
                .append("limitDeliveryTimeDesc", limitDeliveryTimeDesc)
                .append("memberCode", memberCode)
                .append("memberId", memberId)
                .append("needInvoice", needInvoice)
                .append("needToPayAmount", needToPayAmount)
                .append("soPsPackageSkuVOs", soPsPackageSkuVOs)
                .append("soPsPackageVOs", soPsPackageVOs)
                .append("outerOrderCode", outerOrderCode)
                .append("paymentType", paymentType)
                .append("payTime", payTime)
                .append("planedDeliveryDate", planedDeliveryDate)
                .append("pointOnHead", pointOnHead)
                .append("pointOnHeadDeduction", pointOnHeadDeduction)
                .append("priceUnit", priceUnit)
                .append("province", province)
                .append("quantity", quantity)
                .append("Receiver", Receiver)
                .append("receiverPhone", receiverPhone)
                .append("refer", refer)
                .append("remark", remark)
                .append("salesOrderStatus", salesOrderStatus)
                .append("salesOrderType", salesOrderType)
                .append("serviceFeeAmount", serviceFeeAmount)
                .append("shopId", shopId)
                .append("shopName", shopName)
                .append("skuCode", skuCode)
                .append("sourceSoCode", sourceSoCode)
                .append("street", street)
                .append("totalAmount", totalAmount)
                .append("discountOnHead", discountOnHead)
                .append("discountOnLine", discountOnLine)
                .append("totalAmountAfterDiscount", totalAmountAfterDiscount)
                .append("zipCode", zipCode)
                .append("hideFlag", hideFlag)
                .append("buyerNick", buyerNick)
                .append("soInvoiceInfoVO", soInvoiceInfoVO)
                .append("whAllotList", whAllotList)
                .append("opIdCardVO", opIdCardVO)
                .append("crossBorderFlag", crossBorderFlag)
                .append("crossFree", crossFree)
                .append("actualPayFee", actualPayFee)
                .append("thirdpartyOrderCode", thirdpartyOrderCode)
                .append("downloadSource", downloadSource)
                .append("birthdayDiscount", birthdayDiscount)
                .append("thirdChannelCPS",thirdChannelCPS)
                .toString();
    }

	

	public BigDecimal getLimitFeeAmount() {
		return limitFeeAmount;
	}

	public void setLimitFeeAmount(BigDecimal limitFeeAmount) {
		this.limitFeeAmount = limitFeeAmount;
	}

	public BigDecimal getCarriageAmount() {
		return carriageAmount;
	}

	public void setCarriageAmount(BigDecimal carriageAmount) {
		this.carriageAmount = carriageAmount;
	}

	public BigDecimal getBirthdayDiscountAmount() {
		return birthdayDiscountAmount;
	}

	public void setBirthdayDiscountAmount(BigDecimal birthdayDiscountAmount) {
		this.birthdayDiscountAmount = birthdayDiscountAmount;
	}

	public String getInterestsId() {
		return interestsId;
	}

	public void setInterestsId(String interestsId) {
		this.interestsId = interestsId;
	}

	public BigDecimal getCustomizationAmount() {
		return customizationAmount;
	}

	public void setCustomizationAmount(BigDecimal customizationAmount) {
		this.customizationAmount = customizationAmount;
	}

	public BigDecimal getCustomizationDiscount() {
		return customizationDiscount;
	}

	public void setCustomizationDiscount(BigDecimal customizationDiscount) {
		this.customizationDiscount = customizationDiscount;
	}

	public String getDeviceId() {
		return deviceId;
	}

	public void setDeviceId(String deviceId) {
		this.deviceId = deviceId;
	}

	public String getUtmSource() {
		return utmSource;
	}

	public void setUtmSource(String utmSource) {
		this.utmSource = utmSource;
	}

	public String getTradeNo() {
		return tradeNo;
	}

	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}

	public BigDecimal getPointOnLine() {
		return pointOnLine;
	}

	public void setPointOnLine(BigDecimal pointOnLine) {
		this.pointOnLine = pointOnLine;
	}

	public BigDecimal getAccountPayAmount() {
		return accountPayAmount;
	}

	public void setAccountPayAmount(BigDecimal accountPayAmount) {
		this.accountPayAmount = accountPayAmount;
	}

	public BigDecimal getTotalNeedToPayAmount() {
		return totalNeedToPayAmount;
	}

	public void setTotalNeedToPayAmount(BigDecimal totalNeedToPayAmount) {
		this.totalNeedToPayAmount = totalNeedToPayAmount;
	}

	public List<String> getThirdpartyOrderCodes() {
		return thirdpartyOrderCodes;
	}

	public void setThirdpartyOrderCodes(List<String> thirdpartyOrderCodes) {
		this.thirdpartyOrderCodes = thirdpartyOrderCodes;
	}

    public BigDecimal getFundReturnAmount() {
        return fundReturnAmount;
    }

    public void setFundReturnAmount(BigDecimal fundReturnAmount) {
        this.fundReturnAmount = fundReturnAmount;
    }

    public BigDecimal getFundPayAmount() {
        return fundPayAmount;
    }

    public void setFundPayAmount(BigDecimal fundPayAmount) {
        this.fundPayAmount = fundPayAmount;
    }
}
