package com.thebeastshop.salesorder.vo.pub;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class SoPsOrderReportVO implements Serializable{
	
	/**
	 * 订单code
	 */
	private String code;
	
	private String returnCode;
	/**
	 * 支付时间
	 */
    private Date payTime;
    /**
     * 取消时间
     */
    private Date cancelTime;
    /**
     * 总金额
     */
    private BigDecimal totalAmount;
    /**
     * 实示支付金额
     */
    private BigDecimal needToPayAmount;
    /**
     *余额账号
     */
    private BigDecimal accountPayAmount;
    /**
     * 礼品卡支付金额
     */
    private BigDecimal giftCardAmount;
    /**
     * 订单状态
     */
    private Integer salesOrderStatus;
    /**
     * 渠道
     */
    private String channelCode;
    
    /**
     * 折扣
     */
    private BigDecimal discountAmount;
    
    /**
     * 支付金额
     */
    private BigDecimal paymentAmount;
    
  	/**
  	 * 运费
  	 */
  	private BigDecimal carriageAmount=BigDecimal.ZERO;
  	/**
  	 * 限时送达费
  	 */
  	private BigDecimal limitFeeAmount=BigDecimal.ZERO;;
    
    /**
     * 商品数量
     */
    private Integer itemQty;
    /**
     * 取消数量
     */
    private Integer cancleQty;

    
    /**
     * 商品详情
     */
    private List<SoPsOrderItemVO> soPsOrderItemVOs;
    
    /**
     * 支付方式
     */
    private int paymemtType;
    /**
     * 收银员
     */
    private String cashier;
    
    
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Date getPayTime() {
		return payTime;
	}

	public void setPayTime(Date payTime) {
		this.payTime = payTime;
	}

	public Date getCancelTime() {
		return cancelTime;
	}

	public void setCancelTime(Date cancelTime) {
		this.cancelTime = cancelTime;
	}

	public BigDecimal getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(BigDecimal totalAmount) {
		this.totalAmount = totalAmount;
	}

	public BigDecimal getNeedToPayAmount() {
		return needToPayAmount;
	}

	public void setNeedToPayAmount(BigDecimal needToPayAmount) {
		this.needToPayAmount = needToPayAmount;
	}

	public BigDecimal getAccountPayAmount() {
		return accountPayAmount;
	}

	public void setAccountPayAmount(BigDecimal accountPayAmount) {
		this.accountPayAmount = accountPayAmount;
	}

	public BigDecimal getGiftCardAmount() {
		return giftCardAmount;
	}

	public void setGiftCardAmount(BigDecimal giftCardAmount) {
		this.giftCardAmount = giftCardAmount;
	}

	public Integer getSalesOrderStatus() {
		return salesOrderStatus;
	}

	public void setSalesOrderStatus(Integer salesOrderStatus) {
		this.salesOrderStatus = salesOrderStatus;
	}

	public String getChannelCode() {
		return channelCode;
	}

	public void setChannelCode(String channelCode) {
		this.channelCode = channelCode;
	}

	public BigDecimal getDiscountAmount() {
		
		if(totalAmount==null){
			totalAmount = BigDecimal.ZERO;
		}
		if(needToPayAmount==null){
			needToPayAmount = BigDecimal.ZERO;
		}
		
		if(giftCardAmount==null){
			giftCardAmount = BigDecimal.ZERO;
		}
		if(accountPayAmount==null){
			accountPayAmount = BigDecimal.ZERO;
		}
		discountAmount = totalAmount.subtract(needToPayAmount).subtract(giftCardAmount).subtract(accountPayAmount);
		
		return discountAmount;
	}

	public void setDiscountAmount(BigDecimal discountAmount) {
		this.discountAmount = discountAmount;
	}

	public BigDecimal getPaymentAmount() {
		
		if(needToPayAmount==null){
			needToPayAmount = BigDecimal.ZERO;
		}
		
		if(giftCardAmount==null){
			giftCardAmount = BigDecimal.ZERO;
		}
		if(accountPayAmount==null){
			accountPayAmount = BigDecimal.ZERO;
		}
		paymentAmount = needToPayAmount;
		
		return paymentAmount;
	}

	public void setPaymentAmount(BigDecimal paymentAmount) {
		this.paymentAmount = paymentAmount;
	}

	public Integer getItemQty() {
		return itemQty;
	}

	public void setItemQty(Integer itemQty) {
		this.itemQty = itemQty;
	}

	public Integer getCancleQty() {
		return cancleQty;
	}

	public void setCancleQty(Integer cancleQty) {
		this.cancleQty = cancleQty;
	}

	

	public int getPaymemtType() {
		return paymemtType;
	}

	public void setPaymemtType(int paymemtType) {
		this.paymemtType = paymemtType;
	}

	public String getCashier() {
		return cashier;
	}

	public void setCashier(String cashier) {
		this.cashier = cashier;
	}

	public List<SoPsOrderItemVO> getSoPsOrderItemVOs() {
		return soPsOrderItemVOs;
	}

	public void setSoPsOrderItemVOs(List<SoPsOrderItemVO> soPsOrderItemVOs) {
		this.soPsOrderItemVOs = soPsOrderItemVOs;
	}

	public BigDecimal getCarriageAmount() {
		return carriageAmount;
	}

	public void setCarriageAmount(BigDecimal carriageAmount) {
		this.carriageAmount = carriageAmount;
	}

	public BigDecimal getLimitFeeAmount() {
		return limitFeeAmount;
	}

	public void setLimitFeeAmount(BigDecimal limitFeeAmount) {
		this.limitFeeAmount = limitFeeAmount;
	}

	public String getReturnCode() {
		return returnCode;
	}

	public void setReturnCode(String returnCode) {
		this.returnCode = returnCode;
	}

	@Override
	public String toString() {
		return "SoPsOrderReportVO [code=" + code + ", payTime=" + payTime + ", cancelTime=" + cancelTime
				+ ", totalAmount=" + totalAmount + ", needToPayAmount=" + needToPayAmount + ", accountPayAmount="
				+ accountPayAmount + ", giftCardAmount=" + giftCardAmount + ", salesOrderStatus=" + salesOrderStatus
				+ ", channelCode=" + channelCode + ", discountAmount=" + discountAmount + ", paymentAmount="
				+ paymentAmount + ", itemQty=" + itemQty + ", cancleQty=" + cancleQty + "]";
	}
    
    
    

}
