package com.thebeastshop.salesorder.vo.pub;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: SoCateringOrderVO
 * @Description: 餐饮订单
 * @Author xiang.gao
 * @Date 2024/9/3 16:56
 */
public class SoCateringOrderVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 订单ID
     */
    private Long id;

    /**
     * 订单号
     */
    private String code;

    /**
     * 会员CODE
     */
    private String memberCode;

    /**
     * 渠道
     */
    private String channelCode;

    /**
     * 应付金额
     */
    private BigDecimal totalNeedToPayAmount = BigDecimal.ZERO;

    /**
     *
     */
    private Date createTime;

    /**
     * 内部备注
     */
    private String innerRemark;

    /**
     * 商品
     */
    private List<CateringSku> skuList;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public List<CateringSku> getSkuList() {
        return skuList;
    }

    public void setSkuList(List<CateringSku> skuList) {
        this.skuList = skuList;
    }

    public BigDecimal getTotalNeedToPayAmount() {
        return totalNeedToPayAmount;
    }

    public void setTotalNeedToPayAmount(BigDecimal totalNeedToPayAmount) {
        this.totalNeedToPayAmount = totalNeedToPayAmount;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getInnerRemark() {
        return innerRemark;
    }

    public void setInnerRemark(String innerRemark) {
        this.innerRemark = innerRemark;
    }

    /**
     * 商品
     */
    public static class CateringSku {

        /**
         * skuCode
         */
        private String skuCode;

        /**
         * sku名称
         */
        private String nameCn;

        /**
         * 数量
         */
        private Integer quantity;

        /**
         * 单价
         */
        private BigDecimal unitPrice;

        public String getSkuCode() {
            return skuCode;
        }

        public void setSkuCode(String skuCode) {
            this.skuCode = skuCode;
        }

        public String getNameCn() {
            return nameCn;
        }

        public void setNameCn(String nameCn) {
            this.nameCn = nameCn;
        }

        public Integer getQuantity() {
            return quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public BigDecimal getUnitPrice() {
            return unitPrice;
        }

        public void setUnitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
        }
    }



}
