/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo.express;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author Royan
 * @version $Id: PackageInfo.java, v 0.1 2015-11-02 下午5:42
 */
public class SoPackageInfoVO {

    /**
     * 快递单号
     */
    private String deliveryCode;
    /**
     * 获取快递单号时的  订单编码
     * OpSoPackageDeliveryInfo.ext1
     *
     */
    private String expressOrderNo;

    /**
     * 区域编码
     * originCode： 寄件区域   OpSoPackageDeliveryInfo.ext2
     * destCode： 收件区域     OpSoPackageDeliveryInfo.ext3
     */
    private String originCode;
    private String destCode;


    /**
     * 包裹单号
     */
    private String orderNo;
    /**
     * 订单人，姓名，联系方式，邮箱，客户分组(普通、vip、vvip)
     */
    private String custName;
    private String custPhone;
    private String custEmail;
    private String custGroup;

    /**
     * 订单信息
     * 是否匿名，是/否
     */
    private String isAnony;
    /**
     * 是否有卡片、留言，要/不要
     */
    private String isCateNote;
    /**
     * 订单总件数 int
     */
    private int orderNum;
    private String monthlyAccount;
    /**
     * 订单总金额，%.2f
     */
    private Double orderSum;
    /**
     * 实际支付金额
     */
    private Double paySum;
    /**
     * 限时送达
     */
    private String limitDelivery;

    /**
     * 制单时间
     */
    private String orderMakeTime;

    /**
     * 收货信息
     * 姓名，联系方式，地址
     */
    private String recName;
    private String recPhone;
    private String recAddress;

    /**
     * 卡片内容
     */
    private String cardNote;
    /**
     * 备注
     */
    private String remark;
    /**
     * 商品列表
     */
    List<SoPackageSkuInfoVO> skus = new ArrayList<>();

    /**
     * 收货地址 格式如下
     * "正灵芝  女士  13818798733，上海市 上海市 浦东新区 浦东新区海阳路1179 1189号综合部 [200136]"
     * 上海市 上海市 浦东新区
     */
    private String custAddr ;
    private String custTitle;
    private String zipCode;
    /**
     * 预计发货日期
     */
    private Date planedDeliveryDate;
    /**
     * 发货日期
     */
    private Date deliveryDate;
    /**
     * 快递类型
     */
    private Integer expressType;
    /**
     * 包裹主键
     */
    private Long packageId;

    /**
     * 收件人邮编
     */
    private String recPostalCode;

    /**
     * 快递单下载url
     */
    private String expressImgURL;

    /**
     * 快递单本地路径
     * @return
     */
    private String expressImgPath;

    //仓库地址
    private String warehouseAddress;

    //仓库邮编
    private String warehousePostCode;
    //子快递单号
    private String childrenExpressNo;

    private String channelCode;
    public String getOrderNo() {
        return orderNo;
    }

    public String getExpressOrderNo() {
        return expressOrderNo;
    }

    public String getOriginCode() {
        return originCode;
    }

    public void setOriginCode(String originCode) {
        this.originCode = originCode;
    }

    public String getDestCode() {
        return destCode;
    }

    public void setDestCode(String destCode) {
        this.destCode = destCode;
    }

    public void setExpressOrderNo(String expressOrderNo) {
        this.expressOrderNo = expressOrderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getCustName() {
        return custName;
    }

    public String getChildrenExpressNo() {
        return childrenExpressNo;
    }

    public void setChildrenExpressNo(String childrenExpressNo) {
        this.childrenExpressNo = childrenExpressNo;
    }

    public void setCustName(String custName) {
        this.custName = custName;
    }

    public String getMonthlyAccount() {
        return monthlyAccount;
    }

    public void setMonthlyAccount(String monthlyAccount) {
        this.monthlyAccount = monthlyAccount;
    }

    public String getCustPhone() {
        return custPhone;
    }

    public void setCustPhone(String custPhone) {
        this.custPhone = custPhone;
    }

    public String getCustEmail() {
        return custEmail;
    }

    public void setCustEmail(String custEmail) {
        this.custEmail = custEmail;
    }

    public String getCustGroup() {
        return custGroup;
    }

    public void setCustGroup(String custGroup) {
        this.custGroup = custGroup;
    }

    public String getIsAnony() {
        return isAnony;
    }

    public void setIsAnony(String isAnony) {
        this.isAnony = isAnony;
    }

    public String getIsCateNote() {
        return isCateNote;
    }

    public void setIsCateNote(String isCateNote) {
        this.isCateNote = isCateNote;
    }

    public int getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(int orderNum) {
        this.orderNum = orderNum;
    }

    public Double getOrderSum() {
        return orderSum;
    }

    public void setOrderSum(Double orderSum) {
        this.orderSum = orderSum;
    }

    public Double getPaySum() {
        return paySum;
    }

    public void setPaySum(Double paySum) {
        this.paySum = paySum;
    }

    public String getLimitDelivery() {
        return limitDelivery;
    }

    public void setLimitDelivery(String limitDelivery) {
        this.limitDelivery = limitDelivery;
    }

    public String getOrderMakeTime() {
        return orderMakeTime;
    }

    public void setOrderMakeTime(String orderMakeTime) {
        this.orderMakeTime = orderMakeTime;
    }

    public String getRecName() {
        return recName;
    }

    public void setRecName(String recName) {
        this.recName = recName;
    }

    public String getRecPhone() {
        return recPhone;
    }

    public void setRecPhone(String recPhone) {
        this.recPhone = recPhone;
    }

    public String getRecAddress() {
        return recAddress;
    }

    public void setRecAddress(String recAddress) {
        this.recAddress = recAddress;
    }

    public String getCardNote() {
        return cardNote;
    }

    public void setCardNote(String cardNote) {
        this.cardNote = cardNote;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<SoPackageSkuInfoVO> getSkus() {
        return skus;
    }

    public void setSkus(List<SoPackageSkuInfoVO> skus) {
        this.skus = skus;
    }

    public String getCustAddr() {
        return custAddr;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public void setCustAddr(String custAddr) {
        this.custAddr = custAddr;
    }

    public String getCustTitle() {
        return custTitle;
    }

    public void setCustTitle(String custTitle) {
        this.custTitle = custTitle;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public Integer getExpressType() {
        return expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public Long getPackageId() {
        return packageId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public String getRecPostalCode() {
        return recPostalCode;
    }

    public void setRecPostalCode(String recPostalCode) {
        this.recPostalCode = recPostalCode;
    }

    public String getExpressImgURL() {
        return expressImgURL;
    }

    public void setExpressImgURL(String expressImgURL) {
        this.expressImgURL = expressImgURL;
    }

    public String getExpressImgPath() {
        return expressImgPath;
    }

    public void setExpressImgPath(String expressImgPath) {
        this.expressImgPath = expressImgPath;
    }

    public String getWarehousePostCode() {
        return warehousePostCode;
    }

    public void setWarehousePostCode(String warehousePostCode) {
        this.warehousePostCode = warehousePostCode;
    }

    public String getWarehouseAddress() {
        return warehouseAddress;
    }

    public void setWarehouseAddress(String warehouseAddress) {
        this.warehouseAddress = warehouseAddress;
    }
}