package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-03-07 21:55
 */
public enum SoRefundStatusEnum {

    REFUND_STATUS_WAIT_FOR_REFUND(1, "待退款"),

    REFUND_STATUS_FINISHED(2, "已退款")
    ;

    private Integer id;

    private String name;

    SoRefundStatusEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static SoRefundStatusEnum getEnumById(Integer id) {
        for (SoRefundStatusEnum e : SoRefundStatusEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public static String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoRefundStatusEnum.class);
    }

}
