package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 17:57
 */
public enum SoPackageDeliveryTitleEnum {

   MR(1, "先生", "先生"),
   MS(2, "女士", "女士"),
   MISS(3, "小姐", "小姐"),
   UNKNOW(4, "保密", "")

    ;

    private Integer id;

    private String name;

    private String title;

    SoPackageDeliveryTitleEnum(Integer id, String name, String title) {
        this.id = id;
        this.name = name;
        this.title = title;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getTitle() {
        return title;
    }

    public static SoPackageDeliveryTitleEnum getEnumById(Integer id) {
        for (SoPackageDeliveryTitleEnum e : SoPackageDeliveryTitleEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoPackageDeliveryTitleEnum.class);
    }


}
