package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;

/**
 * 卡片类型枚举
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 18:10
 */
public enum SoPackageCardTypeEnum {

    CARD_TYPE_NULL(0, "不需要"),
    CARD_TYPE_BLANK_(1, "空白"),
    CARD_TYPE_GHOSTWRITE(2, "代写")

    ;

    private Integer id;

    private String name;

    SoPackageCardTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static SoPackageCardTypeEnum getEnumById(Integer id) {
        for (SoPackageCardTypeEnum e : SoPackageCardTypeEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoPackageCardTypeEnum.class);
    }


}
