/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo.warehouse;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

/**
 * @author Eric.Lou
 * @version $Id: OpReturnRequestVO.java, v 0.1 2015-08-27 15:25
 */
public class OpReturnRequestVO implements Serializable {

	private static final long serialVersionUID = -2606304921981551208L;

	// constructor
    public OpReturnRequestVO() {

    }

    // original
    private Long id;
    
    private List<Long> idList;

    private Long salesOrderId;

    private String code;

    private Integer isChange;

    private String changeOrderCode;

    private Integer requestBy;

    private String requestChannelCode;

    private Integer needReturnInvoice;

    private String returnWarehouseCode;
    
    private String returnPhysicalWarehouseCode;

    private String deliveryCode;

    private Integer returnStatus;

    private BigDecimal refundAmount;

    private Integer refundType;
    private String refundTypeName;

    private String refundAccount;

    private Date createTime;

    private Date finishTime;
    
    private Integer   refundReasonId;	// 退款原因Id
    private String 	  refundReason;		// 退款原因

    private String remark;

    private Long operatorId;

    private String operatorName;
    
    private String imperfectionsDesc;//残次品说明
    
    private String commandCode;//仓库指令

    private String returnWarehouseName;//退还仓库名称

    private String returnPhysicalWarehouseName;//退还物理仓库名称

    private String salesOrderCode;//订单编号

    private Integer needFinanceReturnRefund;//是否财务打款
    
    private BigDecimal aptGiftCardAmount;			// 礼品卡金额
    private String cardnumAmount;					// 退礼品卡-金额对应数据（例：卡号_金额;卡号_金额）

    private BigDecimal refundCarriageAmount;		// 运费退款
    private BigDecimal refundLimitFeeAmount;		// 限时达运费退款
    private BigDecimal refundCrossBorderFee;		// 海淘退款
    private BigDecimal refundPredeposit;			// 退余额抵扣金额
    private BigDecimal allAmount;					// 所有退款总额（实付+礼品卡+余额抵扣）
    private BigDecimal refundPoint; 				// 退积分
    private BigDecimal refundPointDeduction; 		// 退积分抵扣金额

    private Integer aftersaleType;					// 售后类型（1、仅退款2、退货退款）
    private Integer forPaymentType;					// 结款类型（1.财务打款2.线下打款）
    private Integer sourceType;						// 退款来源 （1、scm2、天猫）
    private Integer tmallAuditStatus;				// 天猫审核状态（0、未审核1、已审核）
    private Date tmallCutoffTime;					// 天猫截止时间
    private Date tmallRemainTime;					// 天猫剩余时间
    private String expressCode;						// 退货快递类code
    private String expressCodeName; 				// 退货快递名称
    private String outerRefundId;					// 外部退款单号
    private Integer outerRefundSign;                // 退款标记（0.未标记，1.已标记）
    private Integer tmallXiaoerSign;                // 天猫小二介入 
    
    private Boolean autoRefund = false;				// 是否符合自动退款
    private Boolean autoRefundSuccess = false;		// 自动退款成功
    private String responseContent;					// 页面显示值
    private boolean needReleaseStock = true;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Long> getIdList() {
		return idList;
	}

	public void setIdList(List<Long> idList) {
		this.idList = idList;
	}

	public Long getSalesOrderId() {
        return salesOrderId;
    }

    public void setSalesOrderId(Long salesOrderId) {
        this.salesOrderId = salesOrderId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getIsChange() {
        return isChange;
    }

    public void setIsChange(Integer isChange) {
        this.isChange = isChange;
    }

    public String getChangeOrderCode() {
        return changeOrderCode;
    }

    public void setChangeOrderCode(String changeOrderCode) {
        this.changeOrderCode = changeOrderCode;
    }

    public Integer getRequestBy() {
        return requestBy;
    }

    public void setRequestBy(Integer requestBy) {
        this.requestBy = requestBy;
    }

	public String getCardnumAmount() {
		return cardnumAmount;
	}

	public void setCardnumAmount(String cardnumAmount) {
		this.cardnumAmount = cardnumAmount;
	}

	public String getRequestChannelCode() {
        return requestChannelCode;
    }

    public void setRequestChannelCode(String requestChannelCode) {
        this.requestChannelCode = requestChannelCode;
    }

    public Integer getNeedReturnInvoice() {
        return needReturnInvoice;
    }

    public void setNeedReturnInvoice(Integer needReturnInvoice) {
        this.needReturnInvoice = needReturnInvoice;
    }

    public String getReturnWarehouseCode() {
        return returnWarehouseCode;
    }

    public void setReturnWarehouseCode(String returnWarehouseCode) {
        this.returnWarehouseCode = returnWarehouseCode;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public Integer getReturnStatus() {
        return returnStatus;
    }

    public void setReturnStatus(Integer returnStatus) {
        this.returnStatus = returnStatus;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public Integer getRefundType() {
        return refundType;
    }

    public void setRefundType(Integer refundType) {
        this.refundType = refundType;
    }

    public String getRefundAccount() {
        return refundAccount;
    }

    public void setRefundAccount(String refundAccount) {
        this.refundAccount = refundAccount;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

  
    public String getCommandCode() {
        return commandCode;
    }

    public void setCommandCode(String commandCode) {
        this.commandCode = commandCode;
    }

    public String getReturnWarehouseName() {
        return returnWarehouseName;
    }

    public void setReturnWarehouseName(String returnWarehouseName) {
        this.returnWarehouseName = returnWarehouseName;
    }

    public String getReturnPhysicalWarehouseName() {
        return returnPhysicalWarehouseName;
    }

    public void setReturnPhysicalWarehouseName(String returnPhysicalWarehouseName) {
        this.returnPhysicalWarehouseName = returnPhysicalWarehouseName;
    }

    public String getSalesOrderCode() {
        return salesOrderCode;
    }

    public void setSalesOrderCode(String salesOrderCode) {
        this.salesOrderCode = salesOrderCode;
    }

    public Integer getNeedFinanceReturnRefund() {
        return needFinanceReturnRefund;
    }

    public void setNeedFinanceReturnRefund(Integer needFinanceReturnRefund) {
        this.needFinanceReturnRefund = needFinanceReturnRefund;
    }

	public String getRefundReason() {
		return refundReason;
	}

	public void setRefundReason(String refundReason) {
		this.refundReason = refundReason;
	}

	public BigDecimal getAptGiftCardAmount() {
		return aptGiftCardAmount;
	}

	public void setAptGiftCardAmount(BigDecimal aptGiftCardAmount) {
		this.aptGiftCardAmount = aptGiftCardAmount;
	}
	
	public Integer getRefundReasonId() {
		return refundReasonId;
	}

	public void setRefundReasonId(Integer refundReasonId) {
		this.refundReasonId = refundReasonId;
	}

	public BigDecimal getRefundCarriageAmount() {
		return refundCarriageAmount;
	}

	public void setRefundCarriageAmount(BigDecimal refundCarriageAmount) {
		this.refundCarriageAmount = refundCarriageAmount;
	}

	public BigDecimal getRefundLimitFeeAmount() {
		return refundLimitFeeAmount;
	}

	public void setRefundLimitFeeAmount(BigDecimal refundLimitFeeAmount) {
		this.refundLimitFeeAmount = refundLimitFeeAmount;
	}

	public BigDecimal getRefundCrossBorderFee() {
		return refundCrossBorderFee;
	}

	public void setRefundCrossBorderFee(BigDecimal refundCrossBorderFee) {
		this.refundCrossBorderFee = refundCrossBorderFee;
	}

	public String getRefundTypeName() {
		return refundTypeName;
	}
	public void setRefundTypeName(String refundTypeName) {
		this.refundTypeName = refundTypeName;
	}

	public BigDecimal getRefundPredeposit() {
		return refundPredeposit;
	}

	public void setRefundPredeposit(BigDecimal refundPredeposit) {
		this.refundPredeposit = refundPredeposit;
	}

	public BigDecimal getAllAmount() {
		return allAmount;
	}

	public void setAllAmount(BigDecimal allAmount) {
		this.allAmount = allAmount;
	}

	public Integer getAftersaleType() {
		return aftersaleType;
	}

	public void setAftersaleType(Integer aftersaleType) {
		this.aftersaleType = aftersaleType;
	}

	public Integer getForPaymentType() {
		return forPaymentType;
	}

	public void setForPaymentType(Integer forPaymentType) {
		this.forPaymentType = forPaymentType;
	}

	public Integer getTmallAuditStatus() {
		return tmallAuditStatus;
	}

	public void setTmallAuditStatus(Integer tmallAuditStatus) {
		this.tmallAuditStatus = tmallAuditStatus;
	}

	public Integer getSourceType() {
		return sourceType;
	}

	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	public Date getTmallCutoffTime() {
		return tmallCutoffTime;
	}

	public void setTmallCutoffTime(Date tmallCutoffTime) {
		this.tmallCutoffTime = tmallCutoffTime;
	}

	public Date getTmallRemainTime() {
		return tmallRemainTime;
	}

	public void setTmallRemainTime(Date tmallRemainTime) {
		this.tmallRemainTime = tmallRemainTime;
	}

	public String getExpressCode() {
		return expressCode;
	}
	public void setExpressCode(String expressCode) {
		this.expressCode = expressCode;
	}

    public String getOuterRefundId() {
		return outerRefundId;
	}

	public void setOuterRefundId(String outerRefundId) {
		this.outerRefundId = outerRefundId;
	}

	

	public Integer getOuterRefundSign() {
		return outerRefundSign;
	}

	public void setOuterRefundSign(Integer outerRefundSign) {
		this.outerRefundSign = outerRefundSign;
	}

  public BigDecimal getRefundPoint() {
    return refundPoint;
  }

  public void setRefundPoint(BigDecimal refundPoint) {
    this.refundPoint = refundPoint;
  }

  public List<Map<String,Object>> getCardNum_AmountList(){
		List<Map<String,Object>> list= new ArrayList<>();
		if(!StringUtils.isBlank(cardnumAmount)){
			String arr[] =  cardnumAmount.split(";");
			if(arr != null && arr.length > 0){
				for(String str : arr){
					String cardNum_AmountSrr[] = str.split("_");
					if(cardNum_AmountSrr.length == 2){
						Map<String,Object> map = new HashMap<String,Object>();
						map.put("cardNum", cardNum_AmountSrr[0]);
						map.put("amount", cardNum_AmountSrr[1]);
						list.add(map);
					}
				}
			}
		}

		return list;
	}

    public Integer getTmallXiaoerSign() {
        return tmallXiaoerSign;
    }

    public void setTmallXiaoerSign(Integer tmallXiaoerSign) {
        this.tmallXiaoerSign = tmallXiaoerSign;
    }
    
    public String getForPaymentTypeName() {
        return forPaymentType == null ? "" :
        		forPaymentType.equals(1) ? "财务打款" :
        			forPaymentType.equals(2) ? "线下渠道打款" :
                        		"";
    }
    
    public String getAftersaleTypeName() {
        return aftersaleType == null ? "" :
        			aftersaleType.equals(1) ? "仅退款" :
        				aftersaleType.equals(2) ? "退货退款" :
        					aftersaleType.equals(3) ? "换货" :
                        		"";
    }
    
    public String getTmallAuditStatusName() {
        return tmallAuditStatus == null ? "" :
        		tmallAuditStatus.equals(0) ? "未审核" :
        			tmallAuditStatus.equals(1) ? "已审核" :
                        		"";
    }

	public String getExpressCodeName() {
		return expressCodeName;
	}
	public void setExpressCodeName(String expressCodeName) {
		this.expressCodeName = expressCodeName;
	}

	public String getReturnPhysicalWarehouseCode() {
		return returnPhysicalWarehouseCode;
	}

	public void setReturnPhysicalWarehouseCode(String returnPhysicalWarehouseCode) {
		this.returnPhysicalWarehouseCode = returnPhysicalWarehouseCode;
	}

	public String getImperfectionsDesc() {
		return imperfectionsDesc;
	}

	public void setImperfectionsDesc(String imperfectionsDesc) {
		this.imperfectionsDesc = imperfectionsDesc;
	}

	

	public Boolean getAutoRefund() {
		return autoRefund;
	}
	public void setAutoRefund(Boolean autoRefund) {
		this.autoRefund = autoRefund;
	}

	public String getResponseContent() {
		return responseContent;
	}
	public void setResponseContent(String responseContent) {
		this.responseContent = responseContent;
	}

	public Boolean getAutoRefundSuccess() {
		return autoRefundSuccess;
	}
	public void setAutoRefundSuccess(Boolean autoRefundSuccess) {
		this.autoRefundSuccess = autoRefundSuccess;
	}

	public BigDecimal getRefundPointDeduction() {
		return refundPointDeduction;
	}

	public void setRefundPointDeduction(BigDecimal refundPointDeduction) {
		this.refundPointDeduction = refundPointDeduction;
	}

  public boolean isNeedReleaseStock() {
    return needReleaseStock;
  }

  public void setNeedReleaseStock(boolean needReleaseStock) {
    this.needReleaseStock = needReleaseStock;
  }
}
