/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo.inner;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.salesorder.enums.SoOrderTypeEnum;
import com.thebeastshop.salesorder.enums.SoPackageCardTypeEnum;
import com.thebeastshop.salesorder.enums.SoPackageDeliveryTypeEnum;
import com.thebeastshop.salesorder.enums.SoPackageStatusEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: SoInPackageVO.java, v 0.1 2015-08-18 13:21
 */
public class SoInPackageVO extends BaseDO {

    private static final long serialVersionUID = 1L;

	// constructor
    public SoInPackageVO() {

    }

    // original
    private Long id;

    private Long salesOrderId;

    private String dispatchWarehouseCode;

    private String changeWarehouseCode;//转仓

    private Long jitPackageReferenceId;

    private String code;

    private Integer packageStatus;

    private Integer deliveryType;

    private Date orderMakeTime;

    private Date expectReceiveDate;

    private Date planedDeliveryDate;

    private Date deliveryTime;
    private Date createTime;
    private String limitDeliveryTimeDesc;

    private Date receiveTime;

    private Integer cardType;

    private String cardContent;

    private String batchNo;

    private String csHint;

    private String remark;
    private String identificationNo;
    private String name;
    private String channelName;
    private Integer expressType;

    private String deliveryCode;

    private String presaleFalg;
    private String skuNameCn;

    private String consignment;
    private String jitFlag;

    private String expressName;
    private String myPackageStatusName;
    private String myDispatchWarehouseName;
    private String zipCode;
    private String fullName;
    private String receiver;
    private String receiverPhone;
    private Integer finishAmount;

    private boolean autoFinish;

    private boolean connectFinish;
    private String skuCode;

    private String nameCn;
    private Integer quantity;
    private String nickName;
    private String email;
    private String channelCode;
    private String packageSkuCode;
    private Integer occupyType;
    // self
    /**
     * 订单VO
     */
    private SoInOrderVO soInOrderVO;

    /**
     * 包裹行
     */
    private List<SoInPackageSkuVO> soInPackageSkuVOList;
    /**
     * 包裹配送
     */
    private SoInPackageDeliveryInfoVO opSoPackageDeliveryInfo;

    /**
     * 是否可修改配送
     */
    private Integer canEditDelivery;

    /**
     * 是否可取消制单
     */
    private Integer canCancelMake;

    // manual generate

    private Integer crossBorderFlag;

    /**
     * 通关方式
     */
    private String clearanWay;
    private String memberCode;
    private String expressTypeName;
    private Boolean validRecord;  // 是否为有效代制作包裹记录

    private String verifiedMobile;

    private String address;


    private String warehouseName;
    private String referenceCode;

    private Integer salesOrderType;

    private String districtFullName;

    private String operatorName;

    private String commandCode;

    //物流单信息

    private String oetDateTime;
    private String detail;
    private String scan;

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getReferenceCode() {
        return referenceCode;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public Boolean getValidRecord() {
        return validRecord;
    }

    public void setValidRecord(Boolean validRecord) {
        this.validRecord = validRecord;
    }
    public String getConsignment() {
        return consignment;
    }

    public boolean isAutoFinish() {
        return autoFinish;
    }

    public void setAutoFinish(boolean autoFinish) {
        this.autoFinish = autoFinish;
    }

    public String getPresaleFalg() {
        return presaleFalg;
    }

    public void setPresaleFalg(String presaleFalg) {
        this.presaleFalg = presaleFalg;
    }

    public void setConsignment(String consignment) {
        this.consignment = consignment;
    }

    public String getJitFlag() {
        return jitFlag;
    }

    public void setJitFlag(String jitFlag) {
        this.jitFlag = jitFlag;
    }
    /* 通关方式编号

    */
    private Short clearanWayId;

    public String getChangeWarehouseCode() {
        return changeWarehouseCode;
    }

    public void setChangeWarehouseCode(String changeWarehouseCode) {
        this.changeWarehouseCode = changeWarehouseCode;
    }

    public Long getJitPackageReferenceId() {
        return jitPackageReferenceId;
    }

    public void setJitPackageReferenceId(Long jitPackageReferenceId) {
        this.jitPackageReferenceId = jitPackageReferenceId;
    }

    public Short getClearanWayId() {
        return clearanWayId;
    }

    public void setClearanWayId(Short clearanWayId) {
        this.clearanWayId = clearanWayId;
    }

    public String getClearanWay() {
        return clearanWay;
    }

    public boolean isConnectFinish() {
        return connectFinish;
    }

    public void setConnectFinish(boolean connectFinish) {
        this.connectFinish = connectFinish;
    }

    public void setClearanWay(String clearanWay) {
        this.clearanWay = clearanWay;
    }


    /**
     private String verifiedMobile;

     /**     * 配送方式
     *
     * @return
     */
    public String getDeliveryTypeName() {
        if (deliveryType == null) return "";
        SoPackageDeliveryTypeEnum soPackageDeliveryTypeEnum = SoPackageDeliveryTypeEnum.getEnumById(deliveryType);
        if (soPackageDeliveryTypeEnum == null) return "";
        return soPackageDeliveryTypeEnum.getName();
    }

    /**
     * 卡片类型
     *
     * @return
     */
    public String getCardTypeName() {
        if (cardType == null) return "";
        SoPackageCardTypeEnum cardTypeEnum = SoPackageCardTypeEnum.getEnumById(cardType);
        if (cardTypeEnum == null) return "";
        return cardTypeEnum.getName();
    }

    /**
     * 订单状态
     *
     * @return
     */
    public String getPackageStatusName() {
        return getPackageStatusName(getPackageStatus());
    }

    public static String getPackageStatusName(Integer packageStatus){
        if (packageStatus == null) return "";
        return  SoPackageStatusEnum.getNameById(packageStatus);
    }

    public void setExpressTypeName(String expressTypeName) {
        this.expressTypeName = expressTypeName;
    }

    /**
     * sku数量
     *
     * @return
     */
    public Integer getSkuQuantity() {
        if (soInPackageSkuVOList == null) {
            return 0;
        }
        Integer quantity = 0;
        for (SoInPackageSkuVO soInPackageSkuVO : soInPackageSkuVOList) {
            quantity += soInPackageSkuVO.getQuantity();

        }
        return quantity;
    }

    public String getPackageSkuCode() {
        return packageSkuCode;
    }

    public void setPackageSkuCode(String packageSkuCode) {
        this.packageSkuCode = packageSkuCode;
    }

    public Integer getOccupyType() {
        return occupyType;
    }

    public void setOccupyType(Integer occupyType) {
        this.occupyType = occupyType;
    }


    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    // auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSalesOrderId() {
        return salesOrderId;
    }

    public void setSalesOrderId(Long salesOrderId) {
        this.salesOrderId = salesOrderId;
    }

    public String getDispatchWarehouseCode() {
        return dispatchWarehouseCode;
    }

    public void setDispatchWarehouseCode(String dispatchWarehouseCode) {
        this.dispatchWarehouseCode = dispatchWarehouseCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getPackageStatus() {
        return packageStatus;
    }

    public void setPackageStatus(Integer packageStatus) {
        this.packageStatus = packageStatus;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Date getOrderMakeTime() {
        return orderMakeTime;
    }

    public void setOrderMakeTime(Date orderMakeTime) {
        this.orderMakeTime = orderMakeTime;
    }

    public Date getExpectReceiveDate() {
        return expectReceiveDate;
    }

    public void setExpectReceiveDate(Date expectReceiveDate) {
        this.expectReceiveDate = expectReceiveDate;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public String getLimitDeliveryTimeDesc() {
        return limitDeliveryTimeDesc;
    }

    public void setLimitDeliveryTimeDesc(String limitDeliveryTimeDesc) {
        this.limitDeliveryTimeDesc = limitDeliveryTimeDesc;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public Integer getCardType() {
        return cardType;
    }

    public void setCardType(Integer cardType) {
        this.cardType = cardType;
    }

    public String getCardContent() {
        return cardContent;
    }

    public void setCardContent(String cardContent) {
        this.cardContent = cardContent;
    }

    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public String getCsHint() {
        return csHint;
    }

    public void setCsHint(String csHint) {
        this.csHint = csHint;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public SoInOrderVO getSoInOrderVO() {
        return soInOrderVO;
    }

    public void setSoInOrderVO(SoInOrderVO soInOrderVO) {
        this.soInOrderVO = soInOrderVO;
    }

    public List<SoInPackageSkuVO> getSoInPackageSkuVOList() {
        return soInPackageSkuVOList;
    }

    public void setSoInPackageSkuVOList(List<SoInPackageSkuVO> soInPackageSkuVOList) {
        this.soInPackageSkuVOList = soInPackageSkuVOList;
    }

    public SoInPackageDeliveryInfoVO getOpSoPackageDeliveryInfo() {
        return opSoPackageDeliveryInfo;
    }

    public void setOpSoPackageDeliveryInfo(SoInPackageDeliveryInfoVO opSoPackageDeliveryInfo) {
        this.opSoPackageDeliveryInfo = opSoPackageDeliveryInfo;
    }

    public String getIdentificationNo() {
        return identificationNo;
    }

    public void setIdentificationNo(String identificationNo) {
        this.identificationNo = identificationNo;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public Integer getCanEditDelivery() {
        return canEditDelivery;
    }

    public void setCanEditDelivery(Integer canEditDelivery) {
        this.canEditDelivery = canEditDelivery;
    }

    public Integer getCanCancelMake() {
        return canCancelMake;
    }

    public void setCanCancelMake(Integer canCancelMake) {
        this.canCancelMake = canCancelMake;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
    public Integer getExpressType() {
        return expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }
    public String getMyDispatchWarehouseName() {
        return myDispatchWarehouseName;
    }

    public void setMyDispatchWarehouseName(String myDispatchWarehouseName) {
        this.myDispatchWarehouseName = myDispatchWarehouseName;
    }
    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getReceiverPhone() {
        return receiverPhone;
    }

    public void setReceiverPhone(String receiverPhone) {
        this.receiverPhone = receiverPhone;
    }

    public Integer getFinishAmount() {
        return finishAmount;
    }

    public void setFinishAmount(Integer finishAmount) {
        this.finishAmount = finishAmount;
    }


    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getVerifiedMobile() {
        return verifiedMobile;
    }

    public void setVerifiedMobile(String verifiedMobile) {
        this.verifiedMobile = verifiedMobile;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuNameCn() {
        return skuNameCn;
    }

    public void setSkuNameCn(String skuNameCn) {
        this.skuNameCn = skuNameCn;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getExpressName() {
        return expressName;
    }

    public void setExpressName(String expressName) {
        this.expressName = expressName;
    }

    public String getMyPackageStatusName() {
        return myPackageStatusName;
    }

    public void setMyPackageStatusName(String myPackageStatusName) {
        this.myPackageStatusName = myPackageStatusName;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public Integer getSalesOrderType() {
        return salesOrderType;
    }

    public void setSalesOrderType(Integer salesOrderType) {
        this.salesOrderType = salesOrderType;
    }

    /**
     * 订单类型
     *
     * @return
     */
    public String getSalesOrderTypeName() {
        if (salesOrderType == null) return "";
        SoOrderTypeEnum orderTypeEnum = SoOrderTypeEnum.getEnumById(salesOrderType);
        if (orderTypeEnum == null) return "";
        return orderTypeEnum.getName();
    }

    public String getDistrictFullName() {
        return districtFullName;
    }

    public void setDistrictFullName(String districtFullName) {
        this.districtFullName = districtFullName;
    }

    public String getOperatorName() { return operatorName; }

    public void setOperatorName(String operatorName) { this.operatorName = operatorName; }

    public String getCommandCode() {
        return commandCode;
    }

    public void setCommandCode(String commandCode) {
        this.commandCode = commandCode;
    }

    public String getOetDateTime() {
        return oetDateTime;
    }

    public void setOetDateTime(String oetDateTime) {
        this.oetDateTime = oetDateTime;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getScan() {
        return scan;
    }

    public void setScan(String scan) {
        this.scan = scan;
    }
}