package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 20:39
 */
public enum SoReturnRequestStatusEnum {

    CANCLE(0, "取消"),

    CREATE(1, "发起"),

    WAITING_CHECK(2, "待审核"),

    WAITING_RECEIVE(3, "待入库"),

    WAITING_CHECK_AFTER_RECEIVE(4, "待审核入库情况"),

    FINISHED(9, "完成")

    ;

    private Integer id;

    private String name;

    SoReturnRequestStatusEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static SoReturnRequestStatusEnum getEnumById(Integer id) {
        for (SoReturnRequestStatusEnum e : SoReturnRequestStatusEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public static String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoReturnRequestStatusEnum.class);
    }

}
