package com.thebeastshop.salesorder.vo.pub;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.salesorder.vo.SoPackageSkuCardVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/***
 * package中对应的sku
 * @author fs
 *
 */
public class SoPsPackageSkuVO extends BaseDO {

    private static final long serialVersionUID = 1161350779736586331L;
    /**
     * 商品行ID
     */
    private Long id;
    /**
     * 由谁添加 1会员2客服
     */
    private Integer addBy;
    /**
     * 品牌id
     */
    private Long brandId;
    /**
     * 分类id
     */
    private Long categroyId;
    /**
     * 是否赠品 0否1是
     */
    private Integer isGift;
    /**
     * 是否来单制作，0否1是
     */
    private Integer isJit;
    /**
     * 如果是赠品，对应购买的主商品的skuCode
     */
    private String mainSkuCode;
    /**
     * 预售id 有值标示预售
     */
    private Long presaleId;
    /**
     * 预售状态
     */
    private Integer presaleStatus;
    /**
     * sku数量
     */
    private Integer quantity;
    /**
     * prod购买数量
     */
    private Integer prodQuantity;
    /**
     * 取消数量
     */
    private Integer cancleQuantity;
    /**
     * 商品特殊备注
     */
    private String remark;
    /**
     * sku编码
     */
    private String skuCode;
    /**
     * 单品折扣金额
     */
    private BigDecimal unitDiscount;
    /**
     * 单品积分
     */
    private BigDecimal unitPoint;
    /**
     * 单品积分抵扣金额
     */
    private BigDecimal unitPointDeduction;
    /**
     * 单价
     */
    private BigDecimal unitPrice;
    /**
     * 总价
     */
    private BigDecimal totalPrice;
    /**
     * 特价
     */
    private BigDecimal discountPrice;
    /**
     * 折扣后金额
     */
    private BigDecimal unitAmountAfterDiscount;
    /**
     * 发货仓
     */
    private String dispatchWarehouseCode;
    /**
     * 预售信息
     */
    private SoPsPresaleVO presaleVO;
    /**
     * 单品折扣后单价
     */
    private BigDecimal unitPriceAfterDiscount = BigDecimal.ZERO;
    /**
     * 子订单号
     */
    private Long oid;
    /**
     * 单品均摊积分
     */
    private BigDecimal sharePoint = BigDecimal.ZERO;
    /**
     * 单品折扣
     */
    private BigDecimal shareDisCount = BigDecimal.ZERO;
    /**
     * 单品礼品卡平摊金额
     */
    private BigDecimal shareGiftCard = BigDecimal.ZERO;
    /**
     * 单品服务费平摊
     */
    private BigDecimal shareServiceFee = BigDecimal.ZERO;
    /**
     * 单品积分金额
     */
    private BigDecimal sharePointDeduction = BigDecimal.ZERO;
    /**
     * 跨境购标注 0普通１跨境购
     */
    private Integer crossBorderFlag;
    /**
     * 净重
     */
    private String weight;
    /**
     * 税号
     */
    private String taxNo;
    /**
     * 行总折扣(单品折扣*数量）
     */
    private BigDecimal totalDiscount = BigDecimal.ZERO;
    /**
     * 品类
     */
    private Long categoryId = 0L;
    /**
     *
     */
    private String categoryCods;
    /**
     * 通关方式（0：未知，1：BC，2：个人）
     */
    private Short clearanceWay = 0;

    /**
     * 快递类型 1店送2联邦3顺丰空运4顺丰陆运5圆通6德邦7海淘顺丰 8自送
     */
    private Integer expressType = 0;
    /**
     * 是否代销，1：是，0：否
     */
    private Integer whetherConsignment = 0;

    /**
     * spvId
     */
    private Long spvId;

    /**
     * 组合商品的prodId
     */
    private Long productId;
    /**
     * 商品code
     */
    private String prodCode;
    /**
     * 赠品
     */
    private List<SoPsPackageSkuVO> gifts = new ArrayList<>();
    /**
     * 抢购活动code
     */
    private String panicBuyCode;
    /**
     * 定制内容
     */
    private List<SoPsPackageSkuCustomizeVO> customizeList;
    /**
     * 定制费
     */
    private BigDecimal customizePrice;
    /**
     * 一级类目code
     */
    private String firstCategoryCode;
    /**
     * 商品的中文名称
     */
    private String nameCn;
    /**
     * 单品运费
     */
    private BigDecimal shareCarriage = BigDecimal.ZERO;
    /**
     * 单品限实送达
     */
    private BigDecimal shareLimitFee = BigDecimal.ZERO;
    /**
     * 库存占用code
     */
    private String referenceCode;
    /**
     * 交货周期，单位天
     */
    private int deliveryPeriod;
    /**
     * 单品优惠卷折扣
     */
    private BigDecimal aptCouponDiscountAmount = BigDecimal.ZERO;
    /**
     * 单个优惠卷折扣
     */
    private BigDecimal aptUCouponDiscountAmount = BigDecimal.ZERO;

    private BigDecimal unitPriceAfterApt;

    private BigDecimal totalPriceAfterApt;
    /**
     * 是否定制
     */
    private Integer isCustomize;
    /**
     * 商品属性(normal:普通，virtual：虚拟，logistics：大家具，flower:鲜花)
     */
    private String prodType;

    /**
     * 权益Id
     */
    private String interestsId;

    /**
     * 数据类型
     */
    private Integer sourceId;

    /**
     * 是否定制了卡片
     */
    private Integer cardCustomized;

    /**
     * 商品定制卡片
     */
    private List<SoPackageSkuCardVO> packageSkuCards;


    /**
     * 基金支付金额单品分摊
     */
    private BigDecimal fundPayAmount;


    /**
     * 基金返还金额单品分摊
     */
    private BigDecimal fundReturnAmount;


    public BigDecimal getSharePoint() {
        return sharePoint;
    }

    public void setSharePoint(BigDecimal sharePoint) {
        this.sharePoint = sharePoint;
    }

    public BigDecimal getShareDisCount() {
        return shareDisCount;
    }

    public void setShareDisCount(BigDecimal shareDisCount) {
        this.shareDisCount = shareDisCount;
    }

    public BigDecimal getShareGiftCard() {
        return shareGiftCard;
    }

    public void setShareGiftCard(BigDecimal shareGiftCard) {
        this.shareGiftCard = shareGiftCard;
    }

    public BigDecimal getShareServiceFee() {
        return shareServiceFee;
    }

    public void setShareServiceFee(BigDecimal shareServiceFee) {
        this.shareServiceFee = shareServiceFee;
    }

    public BigDecimal getSharePointDeduction() {
        return sharePointDeduction;
    }

    public void setSharePointDeduction(BigDecimal sharePointDeduction) {
        this.sharePointDeduction = sharePointDeduction;
    }

    public Long getOid() {
        return oid;
    }

    public Integer getAddBy() {
        return addBy;
    }

    public Long getBrandId() {
        return brandId;
    }

    public Long getCategroyId() {
        return categroyId;
    }

    public String getDispatchWarehouseCode() {
        return dispatchWarehouseCode;
    }

    public Integer getIsGift() {
        return isGift;
    }

    public Integer getIsJit() {
        return isJit;
    }

    public String getMainSkuCode() {
        return mainSkuCode;
    }

    public Long getPresaleId() {
        return presaleId;
    }

    public Integer getPresaleStatus() {
        return presaleStatus;
    }

    public SoPsPresaleVO getPresaleVO() {
        return presaleVO;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public String getRemark() {
        return remark;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public BigDecimal getUnitDiscount() {
        return unitDiscount;
    }

    public BigDecimal getUnitPoint() {
        return unitPoint;
    }

    public BigDecimal getUnitPointDeduction() {
        return unitPointDeduction;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setAddBy(Integer addBy) {
        this.addBy = addBy;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public void setCategroyId(Long categroyId) {
        this.categroyId = categroyId;
    }

    public void setDispatchWarehouseCode(String dispatchWarehouseCode) {
        this.dispatchWarehouseCode = dispatchWarehouseCode;
    }

    public void setIsGift(Integer isGift) {
        this.isGift = isGift;
    }

    public void setIsJit(Integer isJit) {
        this.isJit = isJit;
    }

    public void setMainSkuCode(String mainSkuCode) {
        this.mainSkuCode = mainSkuCode;
    }

    public void setOid(Long oid) {
        this.oid = oid;
    }

    public void setPresaleId(Long presaleId) {
        this.presaleId = presaleId;
    }

    public void setPresaleStatus(Integer presaleStatus) {
        this.presaleStatus = presaleStatus;
    }

    public void setPresaleVO(SoPsPresaleVO presaleVO) {
        this.presaleVO = presaleVO;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public void setUnitDiscount(BigDecimal unitDiscount) {
        this.unitDiscount = unitDiscount;
    }

    public void setUnitPoint(BigDecimal unitPoint) {
        this.unitPoint = unitPoint;
    }

    public void setUnitPointDeduction(BigDecimal unitPointDeduction) {
        this.unitPointDeduction = unitPointDeduction;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public Integer getCancleQuantity() {
        return cancleQuantity;
    }

    public void setCancleQuantity(Integer cancleQuantity) {
        this.cancleQuantity = cancleQuantity;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public String getTaxNo() {
        return taxNo;
    }

    public void setTaxNo(String taxNo) {
        this.taxNo = taxNo;
    }

    public BigDecimal getUnitAmountAfterDiscount() {
        return unitAmountAfterDiscount;
    }

    public void setUnitAmountAfterDiscount(BigDecimal unitAmountAfterDiscount) {
        this.unitAmountAfterDiscount = unitAmountAfterDiscount;
    }

    public BigDecimal getTotalDiscount() {
        return totalDiscount;
    }

    public void setTotalDiscount(BigDecimal totalDiscount) {
        this.totalDiscount = totalDiscount;
    }

    public String getCategoryCods() {
        return categoryCods;
    }

    public void setCategoryCods(String categoryCods) {
        this.categoryCods = categoryCods;
    }

    public BigDecimal getUnitPriceAfterDiscount() {
        return unitPriceAfterDiscount;
    }

    public void setUnitPriceAfterDiscount(BigDecimal unitPriceAfterDiscount) {
        this.unitPriceAfterDiscount = unitPriceAfterDiscount;
    }

    public Short getClearanceWay() {
        return clearanceWay;
    }

    public void setClearanceWay(Short clearanceWay) {
        this.clearanceWay = clearanceWay;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public Integer getExpressType() {
        return expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    public Integer getWhetherConsignment() {
        return whetherConsignment;
    }

    public void setWhetherConsignment(Integer whetherConsignment) {
        this.whetherConsignment = whetherConsignment;
    }

    public String getProdCode() {
        return prodCode;
    }

    public void setProdCode(String prodCode) {
        this.prodCode = prodCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public List<SoPsPackageSkuVO> getGifts() {
        return gifts;
    }

    public void setGifts(List<SoPsPackageSkuVO> gifts) {
        this.gifts = gifts;
    }

    public String getPanicBuyCode() {
        return panicBuyCode;
    }

    public void setPanicBuyCode(String panicBuyCode) {
        this.panicBuyCode = panicBuyCode;
    }

    public BigDecimal getCustomizePrice() {
        return customizePrice;
    }

    public void setCustomizePrice(BigDecimal customizePrice) {
        this.customizePrice = customizePrice;
    }

    public List<SoPsPackageSkuCustomizeVO> getCustomizeList() {
        return customizeList;
    }

    public void setCustomizeList(
            List<SoPsPackageSkuCustomizeVO> customizeList) {
        this.customizeList = customizeList;
    }

    public String getFirstCategoryCode() {
        return firstCategoryCode;
    }

    public void setFirstCategoryCode(String firstCategoryCode) {
        this.firstCategoryCode = firstCategoryCode;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public BigDecimal getShareCarriage() {
        return shareCarriage;
    }

    public void setShareCarriage(BigDecimal shareCarriage) {
        this.shareCarriage = shareCarriage;
    }

    public BigDecimal getShareLimitFee() {
        return shareLimitFee;
    }

    public void setShareLimitFee(BigDecimal shareLimitFee) {
        this.shareLimitFee = shareLimitFee;
    }

    public String getReferenceCode() {
        return referenceCode;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public int getDeliveryPeriod() {
        return deliveryPeriod;
    }

    public void setDeliveryPeriod(int deliveryPeriod) {
        this.deliveryPeriod = deliveryPeriod;
    }

    public BigDecimal getAptCouponDiscountAmount() {
        return aptCouponDiscountAmount;
    }

    public void setAptCouponDiscountAmount(BigDecimal aptCouponDiscountAmount) {
        this.aptCouponDiscountAmount = aptCouponDiscountAmount;
    }

    public BigDecimal getAptUCouponDiscountAmount() {
        return aptUCouponDiscountAmount;
    }

    public void setAptUCouponDiscountAmount(BigDecimal aptUCouponDiscountAmount) {
        this.aptUCouponDiscountAmount = aptUCouponDiscountAmount;
    }

    public Integer getProdQuantity() {
        return prodQuantity;
    }

    public void setProdQuantity(Integer prodQuantity) {
        this.prodQuantity = prodQuantity;
    }

    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getUnitPriceAfterApt() {
        return unitPriceAfterApt;
    }

    public void setUnitPriceAfterApt(BigDecimal unitPriceAfterApt) {
        this.unitPriceAfterApt = unitPriceAfterApt;
    }

    public BigDecimal getTotalPriceAfterApt() {
        return totalPriceAfterApt;
    }

    public void setTotalPriceAfterApt(BigDecimal totalPriceAfterApt) {
        this.totalPriceAfterApt = totalPriceAfterApt;
    }

    public Integer getIsCustomize() {
        return isCustomize;
    }

    public void setIsCustomize(Integer isCustomize) {
        this.isCustomize = isCustomize;
    }

    public String getProdType() {
        return prodType;
    }

    public void setProdType(String prodType) {
        this.prodType = prodType;
    }

    public String getInterestsId() {
        return interestsId;
    }

    public void setInterestsId(String interestsId) {
        this.interestsId = interestsId;
    }

    public Integer getSourceId() {
        return sourceId;
    }

    public void setSourceId(Integer sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getCardCustomized() {
        return cardCustomized;
    }

    public void setCardCustomized(Integer cardCustomized) {
        this.cardCustomized = cardCustomized;
    }

    public List<SoPackageSkuCardVO> getPackageSkuCards() {
        return packageSkuCards;
    }

    public void setPackageSkuCards(List<SoPackageSkuCardVO> packageSkuCards) {
        this.packageSkuCards = packageSkuCards;
    }

    public BigDecimal getFundPayAmount() {
        return fundPayAmount;
    }

    public void setFundPayAmount(BigDecimal fundPayAmount) {
        this.fundPayAmount = fundPayAmount;
    }

    public BigDecimal getFundReturnAmount() {
        return fundReturnAmount;
    }

    public void setFundReturnAmount(BigDecimal fundReturnAmount) {
        this.fundReturnAmount = fundReturnAmount;
    }

    @Override
    public String toString() {
        return "SoPsPackageSkuVO{" +
                "id=" + id +
                ", addBy=" + addBy +
                ", brandId=" + brandId +
                ", categroyId=" + categroyId +
                ", isGift=" + isGift +
                ", isJit=" + isJit +
                ", mainSkuCode='" + mainSkuCode + '\'' +
                ", presaleId=" + presaleId +
                ", presaleStatus=" + presaleStatus +
                ", quantity=" + quantity +
                ", prodQuantity=" + prodQuantity +
                ", cancleQuantity=" + cancleQuantity +
                ", remark='" + remark + '\'' +
                ", skuCode='" + skuCode + '\'' +
                ", unitDiscount=" + unitDiscount +
                ", unitPoint=" + unitPoint +
                ", unitPointDeduction=" + unitPointDeduction +
                ", unitPrice=" + unitPrice +
                ", totalPrice=" + totalPrice +
                ", discountPrice=" + discountPrice +
                ", unitAmountAfterDiscount=" + unitAmountAfterDiscount +
                ", dispatchWarehouseCode='" + dispatchWarehouseCode + '\'' +
                ", presaleVO=" + presaleVO +
                ", unitPriceAfterDiscount=" + unitPriceAfterDiscount +
                ", oid=" + oid +
                ", sharePoint=" + sharePoint +
                ", shareDisCount=" + shareDisCount +
                ", shareGiftCard=" + shareGiftCard +
                ", shareServiceFee=" + shareServiceFee +
                ", sharePointDeduction=" + sharePointDeduction +
                ", crossBorderFlag=" + crossBorderFlag +
                ", weight='" + weight + '\'' +
                ", taxNo='" + taxNo + '\'' +
                ", totalDiscount=" + totalDiscount +
                ", categoryId=" + categoryId +
                ", categoryCods='" + categoryCods + '\'' +
                ", clearanceWay=" + clearanceWay +
                ", expressType=" + expressType +
                ", whetherConsignment=" + whetherConsignment +
                ", spvId=" + spvId +
                ", productId=" + productId +
                ", prodCode='" + prodCode + '\'' +
                ", gifts=" + gifts +
                ", panicBuyCode='" + panicBuyCode + '\'' +
                ", customizeList=" + customizeList +
                ", customizePrice=" + customizePrice +
                ", firstCategoryCode='" + firstCategoryCode + '\'' +
                ", nameCn='" + nameCn + '\'' +
                ", shareCarriage=" + shareCarriage +
                ", shareLimitFee=" + shareLimitFee +
                ", referenceCode='" + referenceCode + '\'' +
                ", deliveryPeriod=" + deliveryPeriod +
                ", aptCouponDiscountAmount=" + aptCouponDiscountAmount +
                ", aptUCouponDiscountAmount=" + aptUCouponDiscountAmount +
                ", unitPriceAfterApt=" + unitPriceAfterApt +
                ", totalPriceAfterApt=" + totalPriceAfterApt +
                ", isCustomize=" + isCustomize +
                ", prodType='" + prodType + '\'' +
                ", interestsId='" + interestsId + '\'' +
                ", sourceId=" + sourceId +
                ", cardCustomized=" + cardCustomized +
                ", packageSkuCards=" + packageSkuCards +
                ", aptFundPayAmount=" + fundPayAmount +
                ", aptFundReturnAmount=" + fundReturnAmount +
                '}';
    }

}
