package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 15:37
 */
public enum SoOrderStatusEnum {

    CANCLE(0, "取消"),

    NONPAYMENT(1, "未付款"),

    HOLD(2, "未付款挂起"),

    NOAUDIT(3, "待审批"),

    CHANGE_AFTER_RECEIVE(5, "换货待收货"),

    HOLD_REVIEW(9, "审单挂起"),

    WAITING_REVIEW(10, "待审单"),

    ALREADY_REVIEW(11, "已审单"),

    ALREADY_FINISHED(12, "已完成")

    ;

    private Integer id;

    private String name;

    SoOrderStatusEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static SoOrderStatusEnum getEnumById(Integer id) {
        for (SoOrderStatusEnum e : SoOrderStatusEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoOrderStatusEnum.class);
    }

}
