/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.utils.NumberUtil;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author Roy.Chen
 * @version $Id: SoPackageSkuReport.java, v 0.1 2015-11-12 14:19
 */
public class SoSkuReportVO extends BaseDO {
	
	
    private String skuCode;
    private String skuName;
    private String skuNameCN;

    private String categoryName;
    private String brandName;

    private Integer quantity;
    
    private List<Integer> soIdListNot;

    /**
     * 总价
     */
    private BigDecimal totalPrice;
    /**
     * 最终支付总价
     */
    private BigDecimal totalPriceAfterApt;
    
    private BigDecimal unitPrice;
    
    private List<SoSkuChannelReportVO> channelVos;
    
    private Integer  currentUserId;
    
    private Integer cancelQuantity;					//	取消数量
    private Integer replenishQuantity;				// 	补货数量
    private Integer returnQuantity;					//	申请退货数量
    private Integer recive_returnQuantity;			//	实际退货数量

    private BigDecimal aptAccountPayAmount;         // 余额抵扣金额
    
    private String createOperatorName;				// 销售人员

    public Integer getCurrentUserId() {
		return currentUserId;
	}

	public void setCurrentUserId(Integer currentUserId) {
		this.currentUserId = currentUserId;
	}

	public List<SoSkuChannelReportVO> getChannelVos() {
		return channelVos;
	}

	public void setChannelVos(List<SoSkuChannelReportVO> channelVos) {
		this.channelVos = channelVos;
	}

	public BigDecimal getUnitPrice() {
		return unitPrice;
	}

	public void setUnitPrice(BigDecimal unitPrice) {
		this.unitPrice = unitPrice;
	}

	public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getSkuNameCN() {
        return skuNameCN;
    }

    public void setSkuNameCN(String skuNameCN) {
        this.skuNameCN = skuNameCN;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Integer getQuantity() {
        return NumberUtil.avoidNull(quantity).intValue();
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getTotalPriceAfterApt() {
        return totalPriceAfterApt;
    }

    public void setTotalPriceAfterApt(BigDecimal totalPriceAfterApt) {
        this.totalPriceAfterApt = totalPriceAfterApt;
    }

	public List<Integer> getSoIdListNot() {
		return soIdListNot;
	}
	public void setSoIdListNot(List<Integer> soIdListNot) {
		this.soIdListNot = soIdListNot;
	}

	public Integer getCancelQuantity() {
		return cancelQuantity;
	}
	public void setCancelQuantity(Integer cancelQuantity) {
		this.cancelQuantity = cancelQuantity;
	}

	public Integer getReplenishQuantity() {
		return replenishQuantity;
	}
	public void setReplenishQuantity(Integer replenishQuantity) {
		this.replenishQuantity = replenishQuantity;
	}

	public Integer getReturnQuantity() {
		return returnQuantity;
	}
	public void setReturnQuantity(Integer returnQuantity) {
		this.returnQuantity = returnQuantity;
	}

	public Integer getRecive_returnQuantity() {
		return recive_returnQuantity;
	}
	public void setRecive_returnQuantity(Integer recive_returnQuantity) {
		this.recive_returnQuantity = recive_returnQuantity;
	}

    public BigDecimal getAptAccountPayAmount() {
        return aptAccountPayAmount;
    }

    public void setAptAccountPayAmount(BigDecimal aptAccountPayAmount) {
        this.aptAccountPayAmount = aptAccountPayAmount;
    }

	public String getCreateOperatorName() {
		return createOperatorName;
	}
	public void setCreateOperatorName(String createOperatorName) {
		this.createOperatorName = createOperatorName;
	}
}