package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;
import com.thebeastshop.payment.enums.PPaymentChannelGroupEnum;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 16:01
 */
public enum SoPaymentTypeEnum {
	TYPE_UNKNOW(-1, "未知"),
	CUSTOMER_SERVICE(0, "客服"),
	TYPE_CASH(1, "现金",PPaymentChannelGroupEnum.CASH),
	TYPE_CARD(2, "刷卡",PPaymentChannelGroupEnum.CREDIT_CARD),
	TYPE_WEIXIN(4, "微信",PPaymentChannelGroupEnum.WXPAY),
	TYPE_ALIPAY(5, "支付宝",PPaymentChannelGroupEnum.ALIPAY),
	TYPE_CMB(6, "招行",PPaymentChannelGroupEnum.CMB),
	TYPE_TRANSFER(7, "转账",PPaymentChannelGroupEnum.TRANSFER),
	PRE_DEPOSIT(8, "预存款",PPaymentChannelGroupEnum.YCK),
	TYPE_PROPRIETOR(9, "业主",PPaymentChannelGroupEnum.YEZHU),
	TYPE_GIFT_CARD(10, "礼品卡",PPaymentChannelGroupEnum.GIFT_CARD),
	TYPE_EXCHANGE(11,"积分",PPaymentChannelGroupEnum.INTEGRAL),
	TYPE_CMB_CSSH(12, "招行掌上生活",PPaymentChannelGroupEnum.CMB),
	TYPE_MARKET_COUPON(13, "商场券",PPaymentChannelGroupEnum.MARKET_COUPON),
	TYPE_QUICK_PASS(14, "银联云闪付", PPaymentChannelGroupEnum.QUICK_PASS_SCAN),
	TYPE_FUND(15, "基金", PPaymentChannelGroupEnum.FUND),
	TYPE_ELEME(16, "饿了么", PPaymentChannelGroupEnum.ELEME),
	TYPE_TM_SHOPPING_FUND(17, "天猫购物金", PPaymentChannelGroupEnum.TM_SHOPPING_FUND),
	TYPE_TM_INTERESTS_FUND(18, "天猫权益金", PPaymentChannelGroupEnum.TM_INTERESTS_FUND),
	SHOPPING_MALL_APP(19, "商场小程序", PPaymentChannelGroupEnum.SHOPPING_MALL_APP);

	private Integer id;

	private String name;
	
	private PPaymentChannelGroupEnum refundChannelEnum;

	SoPaymentTypeEnum(Integer id, String name) {
		this.id = id;
		this.name = name;
	}

	SoPaymentTypeEnum(Integer id, String name,PPaymentChannelGroupEnum refundChannelEnum) {
		this.id = id;
		this.name = name;
		this.refundChannelEnum = refundChannelEnum;
	}
	public Integer getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public static SoPaymentTypeEnum getEnumById(Integer id) {
		for (SoPaymentTypeEnum e : SoPaymentTypeEnum.values()) {
			if (e.getId().equals(id)) {
				return e;
			}
		}
		return null;
	}

	public static String getNameById(Integer id) {
		return EnumUtil.getNameById(id, SoPaymentTypeEnum.class);
	}

	public PPaymentChannelGroupEnum getRefundChannelEnum() {
		return refundChannelEnum;
	}

}
