package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 15:16
 */
public enum SoInvoiceInfoStatusEnum {

    STATUS_INIT(0, "初始"),

    STATUS_WAIT_PROCESS(1, "待开发票"),

    STATUS_FINISHED(2, "已开发票")

    ;

    private Integer id;

    private String name;

    SoInvoiceInfoStatusEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }


    public String getName() {
        return name;
    }

    public static SoInvoiceInfoStatusEnum getEnumById(Integer id) {
        for (SoInvoiceInfoStatusEnum e : SoInvoiceInfoStatusEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }

    public String getNameById(Integer id) {
        return EnumUtil.getNameById(id, SoInvoiceInfoStatusEnum.class);
    }


}
