
/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo.inner;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.salesorder.enums.SoOrderDownloadEnum;
import com.thebeastshop.salesorder.enums.SoOrderStatusEnum;
import com.thebeastshop.salesorder.enums.SoOrderTypeEnum;
import com.thebeastshop.salesorder.enums.SoPaymentTypeEnum;
import org.apache.commons.collections.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;


/**
 * @author Eric.Lou
 * @version $Id: OpSalesOrderVO.java, v 0.1 2015-08-16 14:07
 */
public class SoInOrderVO extends BaseDO {

	private static final long serialVersionUID = -3500148412081892100L;

	// constructor
    public SoInOrderVO() {

    }

    // original
    private Long id;

    private String code;

    private String outerOrderCode;

    private String sourceSoCode;

    private String groupContractCode;
    private String groupContractName;

    private Integer salesOrderType;

    private Integer salesOrderStatus;

    private String channelCode;

    private String memberCode;

    private Long createOperatorId;

    private String createOperatorName;

    private Date createTime;

    private Date cancelTime;

    private Date payTime;

    private Date auditTime;

    private BigDecimal totalAmount;

    private BigDecimal discountOnHead;

    private BigDecimal discountOnLine;

    private BigDecimal totalAmountAfterDiscount;

    private BigDecimal pointOnHead;

    private BigDecimal pointOnLine;

    private BigDecimal pointOnHeadDeduction;

    private BigDecimal pointOnLineDeduction;

    private BigDecimal serviceFeeAmount;

    private BigDecimal giftCardAmount;

    private BigDecimal needToPayAmount;

    private Integer paymentType;

    private Integer isAnonymous;

    private Integer needInvoice;

    private Integer isInvoiceInSamePackage;

    private String couponCode;

    private BigDecimal couponDiscountAmount;

    private String giftCardDesc;

    private String remark;

    private String innerRemark;

    private String foodSpecific;

    private Integer isForceAudit;

    private Integer isDownload;
    
    private Integer crossBorderFlag;

    private BigDecimal crossBorderFee;
	// self
    /**
     * 来源渠道名称
     */
    private String channelName;

    /**
     * 来源渠道类型
     */
    private Integer channelType;

    /**
     * 会员昵称
     */
    private String memberName;
    
    /**
     * 会员手机号
     */
    private String memberMobile;
    

    //第三方订单号
  	private String thirdpartyOrderCode;
  	
  	private Integer gatheringStatus;

	/**
     * 包裹列表
     */
    private List<SoInPackageVO> opSoPackageVOList;
    /**
     * 订单发票信息
     */
    private SoInInvoiceInfoVO soInInvoiceInfoVO;
    
    private BigDecimal receivedPay;			// 已支付金额

    private String replenishReason;			// 补货原因

    private BigDecimal accountPayAmount;	// 账户抵扣金额
    
    private Integer orderType;

    
    
    // manual generate
    
    

    /**
     * 订单类型
     *
     * @return
     */
    public String getSalesOrderTypeName() {
        if (salesOrderType == null) return "";
        SoOrderTypeEnum soOrderTypeEnum = SoOrderTypeEnum.getEnumById(salesOrderType);
        if (soOrderTypeEnum == null) return "";
        return soOrderTypeEnum.getName();
    }

    /**
     * 订单状态
     *
     * @return
     */
    public String getSalesOrderStatusName() {
        return SoInOrderVO.getSalesOrderStatusName(this.salesOrderStatus);
    }
    
    public static String getSalesOrderStatusName(Integer salesOrderStatus){
        SoOrderStatusEnum soOrderStatusEnum = SoOrderStatusEnum.getEnumById(salesOrderStatus);
        if (soOrderStatusEnum == null) return "";
        return soOrderStatusEnum.getName();
    }

    /**
     * 支付方式
     *
     * @return
     */
    public String getPaymentTypeName() {
        return SoInOrderVO.getPaymentTypeName(this.paymentType);
    }
    
    public static String getPaymentTypeName(Integer paymentType){
        SoPaymentTypeEnum paymentTypeEnum = SoPaymentTypeEnum.getEnumById(paymentType);
        if (paymentTypeEnum == null) return "";
        return paymentTypeEnum.getName();
    }

    /**
     * sku个数
     *
     * @return
     */
    public Integer getSkuCount() {
        if (opSoPackageVOList == null) {
            return 0;
        }
        Set<String> skuCodes = new HashSet<String>();
        for (SoInPackageVO soPackageVO : opSoPackageVOList) {
            for (SoInPackageSkuVO opSoPackageSkuVO : soPackageVO.getSoInPackageSkuVOList()) {
                skuCodes.add(opSoPackageSkuVO.getSkuCode());
            }

        }
        if (CollectionUtils.isEmpty(skuCodes)) {
            return 0;
        } else {
            return skuCodes.size();
        }
    }

    public List<SoInPackageSkuVO> getSkuList() {
    	List<SoInPackageSkuVO>  skuList = null;
    	if(CollectionUtils.isNotEmpty(opSoPackageVOList)) {
    		skuList = new ArrayList<SoInPackageSkuVO>();
    		 for (SoInPackageVO soPackageVO : opSoPackageVOList) {
    			  skuList.addAll(soPackageVO.getSoInPackageSkuVOList());
    	        }
    	}
    	return skuList;
    }
    /**
     * sku数量
     *
     * @return
     */
    public Integer getSkuQuantity() {
        if (opSoPackageVOList == null) {
            return 0;
        }
        Integer quantity = 0;
        for (SoInPackageVO soPackageVO : opSoPackageVOList) {
            for (SoInPackageSkuVO opSoPackageSkuVO : soPackageVO.getSoInPackageSkuVOList()) {
                quantity += opSoPackageSkuVO.getQuantity();
            }

        }
        return quantity;
    }

    /**
     * 导出状态名称
     * @return
     */
    public String getIsDownLoadName() {
        if (isDownload == null) return "未导出";
        SoOrderDownloadEnum orderDownloadEnum = SoOrderDownloadEnum.getEnumById(isDownload);
        if (orderDownloadEnum == null) return "未导出";
        return orderDownloadEnum.getName();
    }

    
    public Integer getOrderType() {
		return orderType;
	}

	public void setOrderType(Integer orderType) {
		this.orderType = orderType;
	}

	public BigDecimal getReceivedPay() {
		return receivedPay;
	}

	public void setReceivedPay(BigDecimal receivedPay) {
		this.receivedPay = receivedPay;
	}

	public Integer getGatheringStatus() {
		return gatheringStatus;
	}

	public void setGatheringStatus(Integer gatheringStatus) {
		this.gatheringStatus = gatheringStatus;
	}

	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}
	
	
    public BigDecimal getCrossBorderFee() {
		return crossBorderFee;
	}

	public void setCrossBorderFee(BigDecimal crossBorderFee) {
		this.crossBorderFee = crossBorderFee;
	}

  	
  	public String getThirdpartyOrderCode() {
		return thirdpartyOrderCode;
	}

	public void setThirdpartyOrderCode(String thirdpartyOrderCode) {
		this.thirdpartyOrderCode = thirdpartyOrderCode;
	}

	// auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getOuterOrderCode() {
        return outerOrderCode;
    }

    public void setOuterOrderCode(String outerOrderCode) {
        this.outerOrderCode = outerOrderCode;
    }

    public String getSourceSoCode() {
        return sourceSoCode;
    }

    public void setSourceSoCode(String sourceSoCode) {
        this.sourceSoCode = sourceSoCode;
    }

    public String getGroupContractCode() {
        return groupContractCode;
    }

    public void setGroupContractCode(String groupContractCode) {
        this.groupContractCode = groupContractCode;
    }

    public String getGroupContractName() {
        return groupContractName;
    }

    public void setGroupContractName(String groupContractName) {
        this.groupContractName = groupContractName;
    }

    public Integer getSalesOrderType() {
        return salesOrderType;
    }

    public void setSalesOrderType(Integer salesOrderType) {
        this.salesOrderType = salesOrderType;
    }

    public Integer getSalesOrderStatus() {
        return salesOrderStatus;
    }

    public void setSalesOrderStatus(Integer salesOrderStatus) {
        this.salesOrderStatus = salesOrderStatus;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public Long getCreateOperatorId() {
        return createOperatorId;
    }

    public void setCreateOperatorId(Long createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCancelTime() {
        return cancelTime;
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getDiscountOnHead() {
        return discountOnHead;
    }

    public void setDiscountOnHead(BigDecimal discountOnHead) {
        this.discountOnHead = discountOnHead;
    }

    public BigDecimal getDiscountOnLine() {
        return discountOnLine;
    }

    public void setDiscountOnLine(BigDecimal discountOnLine) {
        this.discountOnLine = discountOnLine;
    }

    public BigDecimal getTotalAmountAfterDiscount() {
        return totalAmountAfterDiscount;
    }

    public void setTotalAmountAfterDiscount(BigDecimal totalAmountAfterDiscount) {
        this.totalAmountAfterDiscount = totalAmountAfterDiscount;
    }

    public BigDecimal getPointOnHead() {
        return pointOnHead;
    }

    public void setPointOnHead(BigDecimal pointOnHead) {
        this.pointOnHead = pointOnHead;
    }

    public BigDecimal getPointOnLine() {
        return pointOnLine;
    }

    public void setPointOnLine(BigDecimal pointOnLine) {
        this.pointOnLine = pointOnLine;
    }

    public BigDecimal getPointOnHeadDeduction() {
        return pointOnHeadDeduction;
    }

    public void setPointOnHeadDeduction(BigDecimal pointOnHeadDeduction) {
        this.pointOnHeadDeduction = pointOnHeadDeduction;
    }

    public BigDecimal getPointOnLineDeduction() {
        return pointOnLineDeduction;
    }

    public void setPointOnLineDeduction(BigDecimal pointOnLineDeduction) {
        this.pointOnLineDeduction = pointOnLineDeduction;
    }

    public BigDecimal getServiceFeeAmount() {
        return serviceFeeAmount;
    }

    public void setServiceFeeAmount(BigDecimal serviceFeeAmount) {
        this.serviceFeeAmount = serviceFeeAmount;
    }

    public BigDecimal getGiftCardAmount() {
        return giftCardAmount;
    }

    public void setGiftCardAmount(BigDecimal giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
    }

    public BigDecimal getNeedToPayAmount() {
        return needToPayAmount;
    }

    public void setNeedToPayAmount(BigDecimal needToPayAmount) {
        this.needToPayAmount = needToPayAmount;
    }

    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    public Integer getIsAnonymous() {
        return isAnonymous;
    }

    public void setIsAnonymous(Integer isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public Integer getNeedInvoice() {
        return needInvoice;
    }

    public void setNeedInvoice(Integer needInvoice) {
        this.needInvoice = needInvoice;
    }

    public Integer getIsInvoiceInSamePackage() {
        return isInvoiceInSamePackage;
    }

    public void setIsInvoiceInSamePackage(Integer isInvoiceInSamePackage) {
        this.isInvoiceInSamePackage = isInvoiceInSamePackage;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public BigDecimal getCouponDiscountAmount() {
        return couponDiscountAmount;
    }

    public void setCouponDiscountAmount(BigDecimal couponDiscountAmount) {
        this.couponDiscountAmount = couponDiscountAmount;
    }

    public String getGiftCardDesc() {
        return giftCardDesc;
    }

    public void setGiftCardDesc(String giftCardDesc) {
        this.giftCardDesc = giftCardDesc;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getInnerRemark() {
        return innerRemark;
    }

    public void setInnerRemark(String innerRemark) {
        this.innerRemark = innerRemark;
    }

    public String getFoodSpecific() {
        return foodSpecific;
    }

    public void setFoodSpecific(String foodSpecific) {
        this.foodSpecific = foodSpecific;
    }

    public Integer getIsDownload() {
        return isDownload;
    }

    public void setIsDownload(Integer isDownload) {
        this.isDownload = isDownload;
    }

    public Integer getIsForceAudit() {
        return isForceAudit;
    }

    public void setIsForceAudit(Integer isForceAudit) {
        this.isForceAudit = isForceAudit;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public Integer getChannelType() {
        return channelType;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public List<SoInPackageVO> getOpSoPackageVOList() {
        return opSoPackageVOList;
    }

    public void setOpSoPackageVOList(List<SoInPackageVO> opSoPackageVOList) {
        this.opSoPackageVOList = opSoPackageVOList;
    }

    public SoInInvoiceInfoVO getSoInInvoiceInfoVO() {
        return soInInvoiceInfoVO;
    }

    public void setSoInInvoiceInfoVO(SoInInvoiceInfoVO soInInvoiceInfoVO) {
        this.soInInvoiceInfoVO = soInInvoiceInfoVO;
    }

    public String getReplenishReason() {
		return replenishReason;
	}
	public void setReplenishReason(String replenishReason) {
		this.replenishReason = replenishReason;
	}

	public String getMemberMobile() {
		return memberMobile;
	}

    public BigDecimal getAccountPayAmount() {
        return accountPayAmount;
    }

    public void setAccountPayAmount(BigDecimal accountPayAmount) {
        this.accountPayAmount = accountPayAmount;
    }

    public void setMemberMobile(String memberMobile) {
		this.memberMobile = memberMobile;
	}
}
