package com.thebeastshop.salesorder.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.delivery.dto.RuleLimitDTO;
import com.thebeastshop.salesorder.dto.wechatGift.SoWechatGiftDto;
import com.thebeastshop.stock.dto.SGroupbuyOwnerOccupyDTO;
import com.thebeastshop.stock.dto.SGroupbuyParterOccupyDTO;
import org.apache.commons.lang3.builder.ToStringBuilder;

/***
 * 订单VO
 *
 * @author fs
 */
public class SoOrderVO implements Serializable{

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

    /**
     * 地址ID
     */
	private Long addressId;

    /**
     * 订单来源渠道编码
     */
    private String channelCode;

    /**
     * 当前渠道的配送仓
     */
    private String dispatchWarehouseCode;

    /**
     * 订单编号
     */
    private String code;

    /**
     * 优惠券Code
     */
    private String couponCode;

    private BigDecimal couponFee = BigDecimal.ZERO;;

    /**
     * 优惠券折扣金额
     */
    private BigDecimal couponDiscountAmount = BigDecimal.ZERO;;

    /**
     * 操作员ID
     */
    private Long createOperatorId;

    /**
     * 操作员名称
     */
    private String createOperatorName;

    /**
     * 创建时间
     */
    private Date createTime;

    private String district;

    /**
     * 期望收货日期
     */
    private Date expectReceiveDate;

    /**
     * 食品特殊备注
     */
    private String foodSpecific;

    /**
     * 礼品卡支付金额
     */
    private BigDecimal giftCardAmount = BigDecimal.ZERO;

    /**
     * 礼品卡卡号,逗号分隔
     */
    private String giftCardDesc;

    /**
     * 储值抵扣金额
     */
    private BigDecimal accountAmount = BigDecimal.ZERO;

    /**
     * 礼品卡信息
     */
    private List<SoOrderGiftCardVO> soOrderGiftCardVOs = new ArrayList<>();

    /**
     * 集团订单关联的合同号
     */
    private String groupContractCode;

    /**
     * 订单ID
     */
    private Long id;

    /**
     * 内部备注
     */
    private String innerRemark;

    /**
     * 是否匿名发货 0否1是
     */
    private Integer isAnonymous;

    /**
     * 是否强制审单
     */
    private Integer isForceAudit;

    /**
     * 发票是否随同货物发送，0否1是
     */
    private Integer isInvoiceInSamePackage;

    /**
     * 限时送达时间描述
     */
    private String limitDeliveryTimeDesc;

    /**
     * 会员编码
     */
    private String memberCode;

    /**
     * 会员ID
     */
    private Long memberId;

    /**
     * 是否需要发票 0否1是
     */
    private Integer needInvoice;

    /**
     * 外部订单号
     */
    private String outerOrderCode;

    /**
     * 支付方式，1现金2借记卡3信用卡4微信5支付宝6招行
     */
    private Integer paymentType;

    /**
     * 支付时间
     */
    private Date payTime;

    /**
     * 预计发货日期
     */
    private Date planedDeliveryDate;

    /**
     * 积分
     */
    private BigDecimal pointOnLine  = BigDecimal.ZERO;

    /**
     * 积分抵扣
     */
    private BigDecimal pointOnLineDeduction  = BigDecimal.ZERO;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 订单来源 推广来源
     */
    private String refer;

    /**
     * 用户备注
     */
    private String remark;

    /**
     * 订单状态
     */
    private Integer salesOrderStatus;

    /**
     * 订单类型，1渠道销售单2渠道换货单3集团订单11礼品订单12样品订单
     */
    private Integer salesOrderType;

    /**
     * 服务费
     */
    private BigDecimal serviceFeeAmount  = BigDecimal.ZERO;

	/**
	 * 总价
	 */
	private BigDecimal totalAmount=BigDecimal.ZERO;

	/**
	 * 订单头折扣
	 */
	private BigDecimal discountOnHead=BigDecimal.ZERO;

	/**
	 * 订单行折扣汇总
	 */
	private BigDecimal discountOnLine=BigDecimal.ZERO;

    /**
     * 折扣后总价
     */
    private BigDecimal totalAmountAfterDiscount=BigDecimal.ZERO;;

    /**
     * 是否隐藏 0否 1是
     */
    private Integer hideFlag;

    /**
     * 第三方渠道
     */
    private CpsInfoVO cpsInfo;

    /**
     * 发票
     */
    private SoInvoiceInfoVO soInvoiceInfoVO;

    /**
     * 身份证信息
     */
    private SoIdentityCardVO soIdentityCardVO;

    /**
     * 跨境购标注 0普通１跨境购
     */
    private Integer crossBorderFlag;

    /**
     * 海淘运输费用
     */
    private BigDecimal crossFree = BigDecimal.ZERO;

    /**
     * 实付金额
     */
	private BigDecimal actualPayFee = BigDecimal.ZERO;

    /**
     * 实付金粉数额
     */
	private BigDecimal actualPayPoint = BigDecimal.ZERO;

    /**
     * 第三方订单号
     */
	private String thirdpartyOrderCode;

    /**
     * APP下载来源
     */
	private String downloadSource;

	/**
     * 生日优惠折扣
     */
    private BigDecimal birthdayDiscount = BigDecimal.ZERO;

    /**
     * 是否生日花
     */
    private boolean birthFlowerUse;

    /**
     * 生日折扣金额
     */
    private BigDecimal birthdayDiscountAmount = BigDecimal.ZERO;

    /**
     * 基金返还金额
     */
    private BigDecimal fundReturnAmount = BigDecimal.ZERO;

    /**
     * 基金支付金额
     */
    private BigDecimal fundPayAmount = BigDecimal.ZERO;

    /**
     * 是否使用生日折扣
     */
    private boolean useBdayDiscount = false;

	/**
	 * 订单类型,1月送鲜花，2 凑钱 3 买赠 4 定制，5配方定制 6浦发 10 团购
	 */
	private int orderType = 0;

	/**
	 * 限时送达费用
	 */
	private BigDecimal limitFee = BigDecimal.ZERO;

	/**
	 * 运费
	 */
	private BigDecimal carriage = BigDecimal.ZERO;

    /**
     * 系统计算运费（用于落单后和手填运费对比）
     */
    private BigDecimal calDeliverPostageAmount = BigDecimal.ZERO;

	/**
	 * 权益Id
	 */
	private String interestsId;

	/**
	 * 定制费
	 */
	private BigDecimal customizationAmount = BigDecimal.ZERO;

	/**
	 * 定制折扣
	 */
	private BigDecimal customizationDiscount = BigDecimal.ZERO;

	/**
	 * 设备Id
	 */
	private String deviceId;

	/**
	 * 投放来源
	 */
	private String utmSource;

    /**
     * 订单组合商品信息
     */
    private List<SoOrderCombinationVO> soOrderCombinations;

    /**
     * 商品类目
     */
    private List<Integer> categoryIds;

    /**
     * 支付交易流水号
     */
    private String tradeNo;
    
    /**
     * true:开团，fase:参团
     */
    private boolean isGroupbuy = true;
    
	/**
	 * 平台
	 */
	private String tbsClient;

	/**
	 * 投放渠道
	 */
	private String tbsUSource;

	/**
	 * 系统
	 */
	private String platForm;

	/**
     * VIP活动Id
     */
    private Integer activityId;
    
    /**
     * VIP卡号
     */
    private String vipCardNo;
    
    /**
     * 地址
     */
    private SoAddressVO soAddressVO;

    /**
     * 收货人
     */
    private String Receiver;

    /**
     * 收货人电话
     */
    private String receiverPhone; 
    
    /**
     * 留言卡
     */
    private SoMessageCardVO soMessageCardVO;

    /**
     * 订单包裹
     */
    private List<SoPackageVO> opSoPackageVOs;

    /**
     * 开团信息
     */
    private SGroupbuyOwnerOccupyDTO sGroupbuyOwnerOccupyDTO;

    /**
     * 参团信息
     */
    private SGroupbuyParterOccupyDTO sGroupbuyParterOccupyDTO;
    
	/**
	 *  抢购
	 */
	private List<CampaignStreamVO> panicVos;

	/**
	 *  换购或买赠
	 */
	private List<CampaignStreamVO> vos;
	
	/**
	 *  抢购
	 */
	private List<CampaignStreamVO> priceDiscountVos;

    /**
     * 运费规则
     */
	private RuleLimitDTO limitRegionVo;

    /**
     * 微信送礼
     */
    private SoWechatGiftDto soWechatGiftDto;

    public List<CampaignStreamVO> getPriceDiscountVos() {
		return priceDiscountVos;
	}

	public void setPriceDiscountVos(List<CampaignStreamVO> priceDiscountVos) {
		this.priceDiscountVos = priceDiscountVos;
	}

	public String getDeviceId() {
		return deviceId;
	}

	public void setDeviceId(String deviceId) {
		this.deviceId = deviceId;
	}

	public String getInterestsId() {
		return interestsId;
	}

	public void setInterestsId(String interestsId) {
		this.interestsId = interestsId;
	}

	public String getDownloadSource() {
		return downloadSource;
	}

	public void setDownloadSource(String downloadSource) {
		this.downloadSource = downloadSource;
	}

	public String getThirdpartyOrderCode() {
		return thirdpartyOrderCode;
	}

	public void setThirdpartyOrderCode(String thirdpartyOrderCode) {
		this.thirdpartyOrderCode = thirdpartyOrderCode;
	}

    public Long getAddressId() {
        return addressId;
    }
   
    public String getChannelCode() {
        return channelCode;
    }

    public String getCode() {
        return code;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public BigDecimal getCouponDiscountAmount() {
        return couponDiscountAmount;
    }

    public Long getCreateOperatorId() {
        return createOperatorId;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public BigDecimal getDiscountOnHead() {
        return discountOnHead;
    }

    public String getDistrict() {
        return district;
    }

    public Date getExpectReceiveDate() {
        return expectReceiveDate;
    }

    public String getFoodSpecific() {
        return foodSpecific;
    }

    public BigDecimal getGiftCardAmount() {
        return giftCardAmount;
    }

    public String getGiftCardDesc() {
        return giftCardDesc;
    }

    public String getGroupContractCode() {
        return groupContractCode;
    }

    public Integer getHideFlag() {
        return hideFlag;
    }

    public Long getId() {
        return id;
    }

    public String getInnerRemark() {
        return innerRemark;
    }

    public Integer getIsAnonymous() {
        return isAnonymous;
    }

    public Integer getIsForceAudit() {
        return isForceAudit;
    }

    public Integer getIsInvoiceInSamePackage() {
        return isInvoiceInSamePackage;
    }

    public String getLimitDeliveryTimeDesc() {
        return limitDeliveryTimeDesc;
    }

    public Long getMemberId() {
        return memberId;
    }

    public Integer getNeedInvoice() {
        return needInvoice;
    }

    public String getOuterOrderCode() {
        return outerOrderCode;
    }

    public Integer getPaymentType() {
        return paymentType;
    }

    public Date getPayTime() {
        return payTime;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public String getRefer() {
        return refer;
    }

    public String getRemark() {
        return remark;
    }

    public Integer getSalesOrderStatus() {
        return salesOrderStatus;
    }

    public Integer getSalesOrderType() {
        return salesOrderType;
    }

    public BigDecimal getServiceFeeAmount() {
        return serviceFeeAmount;
    }
  
    public SoInvoiceInfoVO getSoInvoiceInfoVO() {
        return soInvoiceInfoVO;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public BigDecimal getTotalAmountAfterDiscount() {
        return totalAmountAfterDiscount;
    }

    public void setAddressId(final Long addressId) {
        this.addressId = addressId;
    }
   
    public void setChannelCode(final String channelCode) {
        this.channelCode = channelCode;
    }

    public void setCode(final String code) {
        this.code = code;
    }

    public void setCouponCode(final String couponCode) {
        this.couponCode = couponCode;
    }

    public void setCouponDiscountAmount(final BigDecimal couponDiscountAmount) {
        this.couponDiscountAmount = couponDiscountAmount;
    }

    public void setCreateOperatorId(final Long createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public void setCreateOperatorName(final String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public void setCreateTime(final Date createTime) {
        this.createTime = createTime;
    }

    public void setDiscountOnHead(final BigDecimal discountOnHead) {
        this.discountOnHead = discountOnHead;
    }

    public void setDistrict(final String district) {
        this.district = district;
    }

    public void setExpectReceiveDate(final Date expectReceiveDate) {
        this.expectReceiveDate = expectReceiveDate;
    }

    public void setFoodSpecific(final String foodSpecific) {
        this.foodSpecific = foodSpecific;
    }

    public void setGiftCardAmount(final BigDecimal giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
    }

    public void setGiftCardDesc(final String giftCardDesc) {
        this.giftCardDesc = giftCardDesc;
    }

    public void setGroupContractCode(final String groupContractCode) {
        this.groupContractCode = groupContractCode;
    }

    public void setHideFlag(final Integer hideFlag) {
        this.hideFlag = hideFlag;
    }

    public void setId(final Long id) {
        this.id = id;
    }

    public void setInnerRemark(final String innerRemark) {
        this.innerRemark = innerRemark;
    }

    public void setIsAnonymous(final Integer isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public void setIsForceAudit(final Integer isForceAudit) {
        this.isForceAudit = isForceAudit;
    }

    public void setIsInvoiceInSamePackage(final Integer isInvoiceInSamePackage) {
        this.isInvoiceInSamePackage = isInvoiceInSamePackage;
    }

    public void setLimitDeliveryTimeDesc(final String limitDeliveryTimeDesc) {
        this.limitDeliveryTimeDesc = limitDeliveryTimeDesc;
    }

    public void setMemberId(final Long memberId) {
        this.memberId = memberId;
    }

    public void setNeedInvoice(final Integer needInvoice) {
        this.needInvoice = needInvoice;
    }

    public void setOuterOrderCode(final String outerOrderCode) {
        this.outerOrderCode = outerOrderCode;
    }

    public void setPaymentType(final Integer paymentType) {
        this.paymentType = paymentType;
    }

    public void setPayTime(final Date payTime) {
        this.payTime = payTime;
    }

    public void setPlanedDeliveryDate(final Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public void setQuantity(final Integer quantity) {
        this.quantity = quantity;
    }

    public void setRefer(final String refer) {
        this.refer = refer;
    }

    public void setRemark(final String remark) {
        this.remark = remark;
    }

    public void setSalesOrderStatus(final Integer salesOrderStatus) {
        this.salesOrderStatus = salesOrderStatus;
    }

    public void setSalesOrderType(final Integer salesOrderType) {
        this.salesOrderType = salesOrderType;
    }

    public void setServiceFeeAmount(final BigDecimal serviceFeeAmount) {
        this.serviceFeeAmount = serviceFeeAmount;
    }

    public void setSoInvoiceInfoVO(final SoInvoiceInfoVO soInvoiceInfoVO) {
        this.soInvoiceInfoVO = soInvoiceInfoVO;
    }

    public void setTotalAmount(final BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setTotalAmountAfterDiscount(final BigDecimal totalAmountAfterDiscount) {
        this.totalAmountAfterDiscount = totalAmountAfterDiscount;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(final Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public BigDecimal getCrossFree() {
        return crossFree;
    }

    public void setCrossFree(final BigDecimal crossFree) {
        this.crossFree = crossFree;
    }

	public BigDecimal getDiscountOnLine() {
		return discountOnLine;
	}

	public void setDiscountOnLine(BigDecimal discountOnLine) {
		this.discountOnLine = discountOnLine;
	}

    public BigDecimal getCouponFee() {
		return couponFee;
	}

	public void setCouponFee(BigDecimal couponFee) {
		this.couponFee = couponFee;
	}

	public BigDecimal getBirthdayDiscount() {
		return birthdayDiscount;
	}

	public void setBirthdayDiscount(BigDecimal birthdayDiscount) {
		this.birthdayDiscount = birthdayDiscount;
	}

	public BigDecimal getActualPayFee() {
		return actualPayFee;
	}

	public void setActualPayFee(BigDecimal actualPayFee) {
		this.actualPayFee = actualPayFee;
	}

    public CpsInfoVO getCpsInfo() {
        return cpsInfo;
    }

    public void setCpsInfo(CpsInfoVO cpsInfo) {
        this.cpsInfo = cpsInfo;
    }

	public BigDecimal getBirthdayDiscountAmount() {
		return birthdayDiscountAmount;
	}

	public void setBirthdayDiscountAmount(BigDecimal birthdayDiscountAmount) {
		this.birthdayDiscountAmount = birthdayDiscountAmount;
	}

    public BigDecimal getFundReturnAmount() {
        return fundReturnAmount;
    }

    public void setFundReturnAmount(BigDecimal fundReturnAmount) {
        this.fundReturnAmount = fundReturnAmount;
    }

    public BigDecimal getFundPayAmount() {
        return fundPayAmount;
    }

    public void setFundPayAmount(BigDecimal fundPayAmount) {
        this.fundPayAmount = fundPayAmount;
    }

    public BigDecimal getLimitFee() {
		return limitFee;
	}

	public void setLimitFee(BigDecimal limitFee) {
		this.limitFee = limitFee;
	}

	public BigDecimal getCarriage() {
		return carriage;
	}

	public void setCarriage(BigDecimal carriage) {
		this.carriage = carriage;
	}

    public BigDecimal getCalDeliverPostageAmount() {
        return calDeliverPostageAmount;
    }

    public void setCalDeliverPostageAmount(BigDecimal calDeliverPostageAmount) {
        this.calDeliverPostageAmount = calDeliverPostageAmount;
    }

    public BigDecimal getCustomizationAmount() {
		return customizationAmount;
	}

	public void setCustomizationAmount(BigDecimal customizationAmount) {
		this.customizationAmount = customizationAmount;
	}

	public BigDecimal getCustomizationDiscount() {
		return customizationDiscount;
	}

	public void setCustomizationDiscount(BigDecimal customizationDiscount) {
		this.customizationDiscount = customizationDiscount;
	}

	public String getUtmSource() {
		return utmSource;
	}

	public void setUtmSource(String utmSource) {
		this.utmSource = utmSource;
	}

	public boolean isBirthFlowerUse() {
		return birthFlowerUse;
	}

	public void setBirthFlowerUse(boolean birthFlowerUse) {
		this.birthFlowerUse = birthFlowerUse;
	}

	public boolean isUseBdayDiscount() {
		return useBdayDiscount;
	}

	public void setUseBdayDiscount(boolean useBdayDiscount) {
		this.useBdayDiscount = useBdayDiscount;
	}
	
	public int getOrderType() {
		return orderType;
	}

	public void setOrderType(int orderType) {
		this.orderType = orderType;
	}

	public List<Integer> getCategoryIds() {
		return categoryIds;
	}

	public void setCategoryIds(List<Integer> categoryIds) {
		this.categoryIds = categoryIds;
	}

	public String getDispatchWarehouseCode() {
		return dispatchWarehouseCode;
	}

	public void setDispatchWarehouseCode(String dispatchWarehouseCode) {
		this.dispatchWarehouseCode = dispatchWarehouseCode;
	}
	
	public BigDecimal getPointOnLineDeduction() {
		return pointOnLineDeduction;
	}

	public void setPointOnLineDeduction(BigDecimal pointOnLineDeduction) {
		this.pointOnLineDeduction = pointOnLineDeduction;
	}

	public BigDecimal getPointOnLine() {
		return pointOnLine;
	}

	public void setPointOnLine(BigDecimal pointOnLine) {
		this.pointOnLine = pointOnLine;
	}

	public String getTradeNo() {
		return tradeNo;
	}

	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}

	public boolean isGroupbuy() {
		return isGroupbuy;
	}

	public void setGroupbuy(boolean isGroupbuy) {
		this.isGroupbuy = isGroupbuy;
	}

	public String getTbsClient() {
		return tbsClient;
	}

	public void setTbsClient(String tbsClient) {
		this.tbsClient = tbsClient;
	}

	public String getTbsUSource() {
		return tbsUSource;
	}

	public void setTbsUSource(String tbsUSource) {
		this.tbsUSource = tbsUSource;
	}

	public String getPlatForm() {
		return platForm;
	}

	public void setPlatForm(String platForm) {
		this.platForm = platForm;
	}
	
	public Integer getActivityId() {
		return activityId;
	}

	public void setActivityId(Integer activityId) {
		this.activityId = activityId;
	}

	public String getVipCardNo() {
		return vipCardNo;
	}

	public void setVipCardNo(String vipCardNo) {
		this.vipCardNo = vipCardNo;
	}

	public List<SoOrderGiftCardVO> getSoOrderGiftCardVOs() {
		return soOrderGiftCardVOs;
	}

	public void setSoOrderGiftCardVOs(List<SoOrderGiftCardVO> soOrderGiftCardVOs) {
		this.soOrderGiftCardVOs = soOrderGiftCardVOs;
	}

	public List<SoOrderCombinationVO> getSoOrderCombinations() {
		return soOrderCombinations;
	}

	public void setSoOrderCombinations(List<SoOrderCombinationVO> soOrderCombinations) {
		this.soOrderCombinations = soOrderCombinations;
	}

	public SoIdentityCardVO getSoIdentityCardVO() {
		return soIdentityCardVO;
	}

	public void setSoIdentityCardVO(SoIdentityCardVO soIdentityCardVO) {
		this.soIdentityCardVO = soIdentityCardVO;
	}

	public BigDecimal getActualPayPoint() {
		return actualPayPoint;
	}

	public void setActualPayPoint(BigDecimal actualPayPoint) {
		this.actualPayPoint = actualPayPoint;
	}

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public SoAddressVO getSoAddressVO() {
		return soAddressVO;
	}

	public void setSoAddressVO(SoAddressVO soAddressVO) {
		this.soAddressVO = soAddressVO;
	}

	public SoMessageCardVO getSoMessageCardVO() {
		return soMessageCardVO;
	}

	public void setSoMessageCardVO(SoMessageCardVO soMessageCardVO) {
		this.soMessageCardVO = soMessageCardVO;
	}

	public List<SoPackageVO> getOpSoPackageVOs() {
		return opSoPackageVOs;
	}

	public void setOpSoPackageVOs(List<SoPackageVO> opSoPackageVOs) {
		this.opSoPackageVOs = opSoPackageVOs;
	}

	public SGroupbuyOwnerOccupyDTO getsGroupbuyOwnerOccupyDTO() {
		return sGroupbuyOwnerOccupyDTO;
	}

	public void setsGroupbuyOwnerOccupyDTO(SGroupbuyOwnerOccupyDTO sGroupbuyOwnerOccupyDTO) {
		this.sGroupbuyOwnerOccupyDTO = sGroupbuyOwnerOccupyDTO;
	}

	public SGroupbuyParterOccupyDTO getsGroupbuyParterOccupyDTO() {
		return sGroupbuyParterOccupyDTO;
	}

	public void setsGroupbuyParterOccupyDTO(SGroupbuyParterOccupyDTO sGroupbuyParterOccupyDTO) {
		this.sGroupbuyParterOccupyDTO = sGroupbuyParterOccupyDTO;
	}

	public List<CampaignStreamVO> getPanicVos() {
		return panicVos;
	}

	public void setPanicVos(List<CampaignStreamVO> panicVos) {
		this.panicVos = panicVos;
	}

	public List<CampaignStreamVO> getVos() {
		return vos;
	}

	public void setVos(List<CampaignStreamVO> vos) {
		this.vos = vos;
	}

	public String getReceiver() {
		return Receiver;
	}

	public void setReceiver(String receiver) {
		Receiver = receiver;
	}

	public String getReceiverPhone() {
		return receiverPhone;
	}

	public void setReceiverPhone(String receiverPhone) {
		this.receiverPhone = receiverPhone;
	}

	public RuleLimitDTO getLimitRegionVo() {
		return limitRegionVo;
	}

	public void setLimitRegionVo(RuleLimitDTO limitRegionVo) {
		this.limitRegionVo = limitRegionVo;
	}

    public BigDecimal getAccountAmount() {
        return accountAmount;
    }

    public void setAccountAmount(BigDecimal accountAmount) {
        this.accountAmount = accountAmount;
    }

    public SoWechatGiftDto getSoWechatGiftDto() {
        return soWechatGiftDto;
    }

    public void setSoWechatGiftDto(SoWechatGiftDto soWechatGiftDto) {
        this.soWechatGiftDto = soWechatGiftDto;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
