package com.thebeastshop.privilege.exception;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/4/17 14:21 
 */
public enum PrivilegeErrorCode {

    /*************************************会员特权服务错误码配置***************************************/
    SYSTEM_ERROR("0000", "系统错误"),
    GET_MY_PRIVILEGE_ERROR("0001","获取我的特权失败"),
    GET_MY_PRIVILEGE_DETAIL_ERROR("0002","获取我的特权详情失败"),
    GET_MY_PRIVILEGE_DETAIL_EMPTY("0003","获取我的特权详情为空"),
    GET_MY_BENEFITS_ERROR("0004","获取我的福利失败"),
    GET_MY_PRIVILEGE_INSTANCE_ERROR("0005","获取我的特权实例失败"),
    ADD_MY_PRIVILEGE_RECORD_ERROR("0006","新增领取记录失败"),
    GET_MY_PRIVILEGE_REMINDER_ERROR("0007","获取我的提醒失败"),
    ALREADY_GET_MY_PRIVILEGE_GRADE_BAG("0008","已领取过该等级礼包"),
    ALREADY_GET_MY_PRIVILEGE_MONTH_FREE("0009","已领取过每月免邮福利"),
    QUERY_CURRENT_MONTH_RECEIVE("00010","查询当月领取记录失败")
    ;
    private String code;
    private String desc;

    private static final String ERROR_CODE_PREFIX = "PRIVILEGE";

    PrivilegeErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return ERROR_CODE_PREFIX + code;
    }

    public String getDesc() {
        return desc;
    }
}
