package com.thebeastshop.privilege.service;

import java.util.Date;
import java.util.List;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.privilege.cond.PrivilegeInstanceCond;
import com.thebeastshop.privilege.vo.PrivilegeInstanceVO;
import com.thebeastshop.privilege.vo.PrivilegeRecordVO;
import com.thebeastshop.privilege.vo.PrivilegeTemplateVO;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/4/17 19:41
 */
public interface PrivilegeService {
    /**
     * 获取我的特权信息
     * @param memberLevel 会员等级
     * @return
     */
    ServiceResp<List<PrivilegeTemplateVO>> getUserPrivilege(Integer memberLevel);

    ServiceResp<List<PrivilegeTemplateVO>> getUserPrivilegeNew(PrivilegeInstanceCond cond);

    /**
     * 获取我的福利信息
     * @param cond
     * @return
     */
    ServiceResp<PageQueryResp<PrivilegeInstanceVO>> getUserBenefits(PrivilegeInstanceCond cond);

    ServiceResp<PageQueryResp<PrivilegeInstanceVO>> getUserBenefitsByFree(PrivilegeInstanceCond cond);


    /**
     * 获取特权详情
     * @param memberId 会员ID
     * @param templateId 模板ID
     */
    ServiceResp<PrivilegeTemplateVO> getUserPrivilegeDetail(Integer memberId, Integer templateId, Date upgradeDate);


    /**
     * 获取去提醒列表
     * @param memberLevel 会员等级
     * @param memberLevel 会员ID
     * @return
     */
    ServiceResp<List<PrivilegeTemplateVO>> getRemindPrivilege(Integer memberLevel, Integer memberId, Date date);

    /**
     * 点击领取根据模板ID查询实例返回实例
     * @param templateId 模板ID
     * @return
     */
    ServiceResp<List<PrivilegeInstanceVO>> queryByTemplateId(Integer templateId,Integer memberId);
    
    /**
     * 查询当月是否领取(针对老虎、大象每月免邮)
     * @param memberId
     * @return ServiceResp<Boolean>
     */
    ServiceResp<Boolean> queryCurMonthReceive(Integer memberId);

    /**
     * 领取特权或福利
     * @param privilegeRecordVO 领取记录VO
     * @return
     */
    ServiceResp<Boolean> receivePrivilege(PrivilegeRecordVO privilegeRecordVO);
    
    /**
   	 * 合并特权
   	 * 
   	 * @param taskId
   	 *            合并任务ID
   	 * @param mainMemberId
   	 *            主账号ID
   	 * @param subMemberId
   	 *            子账号ID
   	 * @return
   	 */
    ServiceResp<Boolean> merge(Long taskId, Long mainMemberId, Long subMemberId);

    /**
     * 合并发放特权
     *
     * @param mainMemberId
     *            主账号ID
     * @param subMemberId
     *            子账号ID
     * @return
     */
    ServiceResp<Boolean> mergeGrantPrivileges(Long mainMemberId, Long subMemberId);
    

    /**
     * 补发特权
     * 
     * @param dateBetween
     * 			时间区间 以"|"分隔
     * @param instanceId
     * 			实例ID
     * @return 
     */
    ServiceResp<String> remedyPrivilege(String dateBetween, Integer instanceId) ;
    /**
     * 自动发放等级礼包
     *
     * @param nLevel
     * 			新等级
     * @param oLevel
     * 			老等级
     * @return
     */
    ServiceResp<Boolean> queryChangeLevel(Long memberId,Integer oLevel, Integer nLevel);

    /**
     * 发放等级礼包
     * @param templateId 模板ID
     * @return
     */
    ServiceResp<Boolean> grantGiftBagToMember(Integer templateId,Integer memberId);

}
