package com.thebeastshop.privilege.enumeration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Created by xiaodong.cheng on 2018/12/18.
 */
public enum OccupyTypeEnum {
    NOW(1,"现货"),
    PRESALE(2,"预售"),
    ;

    private Integer id;
    private String name;
    public static final List<OccupyTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(OccupyTypeEnum.values()));

    OccupyTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static OccupyTypeEnum getEnumById(Integer id) {
        OccupyTypeEnum[] values = OccupyTypeEnum.values();
        for (OccupyTypeEnum item : values) {
            if (item.getId().equals(id)) {
                return item;
            }
        }
        return null;
    }
}
