package com.thebeastshop.privilege.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.privilege.cond.StoreRentCond;
import com.thebeastshop.privilege.cond.StoreRentConfigCond;
import com.thebeastshop.privilege.vo.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface StoreRentService {
    ServiceResp<StoreRentVO> findById(Integer id);
    ServiceResp<BigDecimal> getCommissionRent(String channelCode,String computeMonth);


    ServiceResp<Integer> addItems(List<StoreRentItemsVO> rentItemsVOList);
    ServiceResp<Integer> deleteItems(List<Integer> rentItemsIdList);
    ServiceResp<List<StoreRentItemsVO>> findItemsByRentIds(List<Integer> rentIdList);


    ServiceResp<PageQueryResp<StoreRentVO>> findCond(StoreRentCond cond);
    ServiceResp<List<StoreRentVO>> exportRent(StoreRentCond cond);
    ServiceResp<Integer> save(StoreRentVO vo);

    ServiceResp<Integer> generateStoreRentMonthData();

    ServiceResp<PageQueryResp<StoreRentConfigDetailVO>> findConfigCond(StoreRentConfigCond cond);
    ServiceResp<List<StoreRentConfigDetailVO>> findConfigCondByList(StoreRentConfigCond cond);
    ServiceResp<Integer> createConfig(StoreRentConfigVO vo);
    ServiceResp<Integer> updateCofigDetail(StoreRentConfigDetailVO vo);

    List<ValueLabelIntVO> findkingdeeCompanyDropList();

    List<ValueLabelVO> findComputeMonthDropList();

    List<ValueLabelVO> getFeeSubjectItemList();

    Map<String,String> getFeeSubjectMap();


}
