/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pcs.vo;

import com.thebeastshop.pcs.enums.PoCostTypeExtEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PcsPurchaseOrderCostVO
implements Serializable {
    public static final Short COST_TYPE_MOLD = 1;
    public static final Short COST_TYPE_PLATE = 2;
    public static final Short COST_TYPE_FREIGHT = 3;
    public static final Short COST_TYPE_OTHER = 4;
    public static final String PO_CURRENCY_FOR_CNY = "CNY";
    public static final List<Integer> PO_COST_TYPE_LIST = new ArrayList<Integer>(){
        {
            this.add(COST_TYPE_MOLD.intValue());
            this.add(COST_TYPE_PLATE.intValue());
            this.add(COST_TYPE_FREIGHT.intValue());
            this.add(COST_TYPE_OTHER.intValue());
        }
    };
    public static final Map<Integer, String> PO_COST_TYPE_MAP = new HashMap<Integer, String>(){
        {
            this.put(COST_TYPE_MOLD.intValue(), "\u6a21\u5177\u8d39");
            this.put(COST_TYPE_PLATE.intValue(), "\u5236\u7248\u8d39");
            this.put(COST_TYPE_FREIGHT.intValue(), "\u8fd0\u8d39");
            this.put(COST_TYPE_OTHER.intValue(), "\u5176\u5b83\u8d39\u7528");
        }
    };
    public static final Map<Integer, String> PO_COST_TYPE_EXT_MAP = new HashMap<Integer, String>(){
        {
            this.put(PoCostTypeExtEnum.payment_for_goods.getKey(), PoCostTypeExtEnum.payment_for_goods.getValue());
        }
    };
    private static final long serialVersionUID = 8104244578934735698L;
    private Long id;
    private Long poId;
    private Short costType;
    private BigDecimal rate;
    private BigDecimal taxes;
    private BigDecimal preTaxesAmount;
    private BigDecimal afterTaxesAmount;
    private Date createTime;

    public static String getCostTypeName(Short costType) {
        return COST_TYPE_MOLD.equals(costType) ? "\u6a21\u5177\u8d39" : (COST_TYPE_PLATE.equals(costType) ? "\u5236\u7248\u8d39" : (COST_TYPE_FREIGHT.equals(costType) ? "\u8fd0\u8d39" : (COST_TYPE_OTHER.equals(costType) ? "\u5176\u5b83\u8d39\u7528" : "")));
    }

    public String getCostTypeName() {
        return PcsPurchaseOrderCostVO.getCostTypeName(this.getCostType());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPoId() {
        return this.poId;
    }

    public void setPoId(Long poId) {
        this.poId = poId;
    }

    public Short getCostType() {
        return this.costType;
    }

    public void setCostType(Short costType) {
        this.costType = costType;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public BigDecimal getTaxes() {
        return this.taxes;
    }

    public void setTaxes(BigDecimal taxes) {
        this.taxes = taxes;
    }

    public BigDecimal getPreTaxesAmount() {
        return this.preTaxesAmount;
    }

    public void setPreTaxesAmount(BigDecimal preTaxesAmount) {
        this.preTaxesAmount = preTaxesAmount;
    }

    public BigDecimal getAfterTaxesAmount() {
        return this.afterTaxesAmount;
    }

    public void setAfterTaxesAmount(BigDecimal afterTaxesAmount) {
        this.afterTaxesAmount = afterTaxesAmount;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getChangeLog() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ").append(this.getCostTypeName()).append(this.formatToNumber(this.afterTaxesAmount)).append(", \u7a0e\u7387:").append(this.formatToNumber(this.rate.multiply(new BigDecimal(100)))).append("%");
        return stringBuilder.toString();
    }

    public String formatToNumber(BigDecimal obj) {
        DecimalFormat df = new DecimalFormat("#.0000");
        if (obj.compareTo(BigDecimal.ZERO) == 0) {
            return "0.0000";
        }
        if (obj.compareTo(BigDecimal.ZERO) > 0 && obj.compareTo(new BigDecimal(1)) < 0) {
            return "0" + df.format(obj).toString();
        }
        return df.format(obj).toString();
    }
}

