package com.thebeastshop.payment.dto;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.payment.enums.PPaymentChannelEnum;

import java.math.BigDecimal;
import java.util.List;

/**
 * 礼品卡支付渠道
 *
 * @Class Name PGiftCardPaymentDTO
 * @Author Xiang.Gao
 * @Create In 2017-12-19
 */
public class PGiftCardPaymentDTO extends PPaymentDTO {

    /**
     * @Field long serialVersionUID
     */
    private static final long serialVersionUID = 1L;

    /**
     * 卡消费信息列表
     *
     * @Field String cardInfos
     */
    private List<CardInfo> cardInfos;

    /**
     * 类目ID 集合
     *
     * @Field List<Integer> categoryIds
     */
    private List<Integer> categoryIds;

    public PGiftCardPaymentDTO() {
        super(PPaymentChannelEnum.GIFT_CARD);
    }

    public List<Integer> getCategoryIds() {
        return categoryIds;
    }

    public void setCategoryIds(List<Integer> categoryIds) {
        this.categoryIds = categoryIds;
    }

    public List<CardInfo> getCardInfos() {
        return cardInfos;
    }

    public void setCardInfos(List<CardInfo> cardInfos) {
        this.cardInfos = cardInfos;
    }

    /**
     * 卡消费信息
     */
    public static class CardInfo extends BaseDO {
        /**
         * 卡号
         */
        private String cardNo;
        /**
         * 消费金额
         */
        private BigDecimal consumeAmount;

        public String getCardNo() {
            return cardNo;
        }

        public void setCardNo(String cardNo) {
            this.cardNo = cardNo;
        }

        public BigDecimal getConsumeAmount() {
            return consumeAmount;
        }

        public void setConsumeAmount(BigDecimal consumeAmount) {
            this.consumeAmount = consumeAmount;
        }
    }

}
