package com.thebeastshop.payment.dto;

import org.apache.commons.lang3.StringUtils;

import com.thebeastshop.payment.enums.PPaymentChannelEnum;

/**
 * 信用卡支付渠道
 *
 * @Class Name PBankCardPaymentDTO
 * @Author Xiang.Gao
 * @Create In 2017-12-19
 */
public class PCreditCardPaymentDTO extends PPaymentDTO {

	/**
	 * @Field long serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 信用卡交易流水号
	 *
	 * @Field String creditTradeCode
	 */
	private String creditTradeCode;

	public PCreditCardPaymentDTO() {
		super(PPaymentChannelEnum.CREDIT_CARD);
	}

	public String getCreditTradeCode() {
		return creditTradeCode;
	}

	public void setCreditTradeCode(String creditTradeCode) {
		this.creditTradeCode = creditTradeCode;
	}

	@Override
	public String getPaymentBusinessCode() {
		if(StringUtils.isNotBlank(creditTradeCode)){
			return creditTradeCode;
		}
		return super.getPaymentBusinessCode();
	}

}
