package com.thebeastshop.payment.service;

import com.thebeastshop.payment.vo.TradeCheckVO;

import java.util.List;

/**
 * 支付定时任务服务
 *
 * @author Paul-xiong
 * @date 2018年1月11日
 * @description
 */
public interface PPaymentJobService {

	/**
	 * 更新支付流水状态
	 */
	void updatePaymentTradeStatus();

	/**
	 * 检查本地取消状态的订单的状态
	 * @param date 哪一天,用YYYYMMDD表示
	 */
	List<TradeCheckVO> checkLocalCancelTrade(String date,int days);

	/**
	 * 检查某一个订单的本地和远程的状态
	 * @param tradeCode
	 * @return
	 */
	TradeCheckVO checkTrade(String tradeCode);

	/**
	 * 根据订单查询远程并且发送kafka
	 * @param outTradeCode
	 * @return
	 */
	void processRemoteTradeAndUpdate(String outTradeCode);

}
