package com.thebeastshop.payment.service;

import java.util.List;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.payment.dto.PPaymentQueryCondDTO;
import com.thebeastshop.payment.vo.PPaymentTradeVO;
import com.thebeastshop.payment.vo.PThirdPaymentInfoVO;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-12-20 19:42
 */
public interface PPaymentTradeService {

	/**
	 * 根据流水号查询支付信息
	 *
	 * @param tradeCode
	 * @return
	 */
	PPaymentTradeVO getTradeByTradeCode(String tradeCode);

	/**
	 * 根据第三方支付平台流水号查询支付信息
	 *
	 * @param thirdPartyTradeCode
	 * @return
	 */
	PPaymentTradeVO getTradeByThirdPartyTradeCode(String thirdPartyTradeCode);

	/**
	 * 根据外部流水号查询流水记录
	 *
	 * @param outTradeCode
	 * @return
	 */
	List<PPaymentTradeVO> getTradeListByOutTradeCode(String outTradeCode);

	/**
	 * 根据会员Id查询相关支付流水记录
	 * 
	 * @param memberId
	 * @return
	 */
	List<PPaymentTradeVO> getTradeListByMemberId(Long memberId);

	/**
	 * 查询更新状态定时任务的支付流水记录
	 * 
	 * @return
	 */
	List<PPaymentTradeVO> getTradeListForUpdateStatusJob();

	/**
	 * 通过条件分页查询
	 * 
	 * @param dto
	 * @return
	 */
	PageQueryResp<PPaymentTradeVO> getPageByCond(PPaymentQueryCondDTO dto);
	
	/**
	 * 根据订单查询已支付流水
	 * 
	 * @param outTradeCode
	 * @return
	 */
	List<PPaymentTradeVO> getPaidByOutTradeCode(String outTradeCode);
	
	/**
	 * 根据订单获取第三方支付信息
	 * 
	 * @param outTradeCode
	 * @return
	 */
	PThirdPaymentInfoVO getThirdPaymentInfo(String outTradeCode);

}
