/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.payment.service;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.payment.dto.PPaymentDTO;
import com.thebeastshop.payment.vo.PPaymentResultVO;
import com.thebeastshop.payment.vo.redirect.PRedirectRequestVO;

/**
 * @author Paul-xiong
 * @date 2017年11月10日
 * @description 支付服务
 */
public interface PPaymentService {

	/**
	 * 服务端支付
	 * 
	 * @param dto
	 * @return
	 */
	ServiceResp<PPaymentResultVO> pay(PPaymentDTO dto);

	/**
	 * 本地支付
	 * 
	 * @param dto
	 * @return
	 */
	ServiceResp<Boolean> payForLocal(PPaymentDTO dto);

	/**
	 * 客户端支付
	 * 
	 * @param dto
	 * @return
	 */
	ServiceResp<PRedirectRequestVO> payForRedirectURL(PPaymentDTO dto);

	/**
	 * 退款
	 * 
	 * @param dto
	 * @return
	 */
	ServiceResp<Boolean> refund(PPaymentDTO dto);

	/**
	 * 撤销
	 * 
	 * @param outTradeCode
	 * @return
	 */
	ServiceResp<Boolean> cancel(String outTradeCode);

}
